#ifndef TASK_H_
#define TASK_H_

#include "mbed.h"
#include "config.h"

/*
 * command characters
 */
 
#define CMD_TEST_REWARD     'T'
#define CMD_CLEAR_INDEX     'O'
#define CMD_EXECUTE         'X'

#define CFG_DELAY_MIN       'm', (1000)
#define CFG_DELAY_VAR       'd', (3000)
#define CFG_PREP_DUR        'p', (500)
#define CFG_AUD_DUR         'a', (5000)
#define CFG_AUD_FREQ        'f', (4)
#define CFG_RESP_DUR        'y', (1500)
#define CFG_POST_DUR        'n', (3000)
#define CFG_REWARD_DUR      'r', (50)
#define CFG_ONSET_MIN       'o', (500)
#define CFG_ONSET_STEPS     's', (10)
#define CFG_VIS_DUR         'v', (800)
#define CFG_VIS_TEST_EVERY  'q', (30)
#define CFG_WHISK_DEBOUNCE  'w', (5)
#define CFG_LICK_DEBOUNCE   'l', (80)

enum Mode {
    Pair,
    Report,
    Stage,
    Associate,
    Motion,
    MotionAlt
};

struct ModeSelection: public config::CommandResponder
{
    static const char CMD_ID_MODE;
    static const char CMD_MODE_PAIR;
    static const char CMD_MODE_STAGE;
    static const char CMD_MODE_REPORT;
    static const char CMD_MODE_ASSOCIATE;
    static const char CMD_MODE_MOTION;
    static const char CMD_MODE_MOTION_ALT;
    
    ModeSelection(); // not allowed
    
    explicit ModeSelection(const Mode& defaultValue);
    
    virtual ~ModeSelection();
    
    // the interface function defined in CommandResponder
    virtual bool parse(const char& c);
    
    // the interface function defined in CommandResponder
    virtual bool writeSettings();
    
    // the interface function defined in CommandResponder
    virtual void echoback();
    
    Mode value;
};

struct Task {
    ModeSelection       mode;           // the trial mode.
    
    Property<uint16_t>  delay_min_ms;   // the minimum duration for the delay.
    
    Property<uint16_t>  delay_var_ms;   // the average for the (exponential) variable 
                                        // duration of the delay.
                                
    Property<uint16_t>  prep_dur_ms;    // the duration of the "preparatory period", 
                                // during which licking is not allowed.
    
    Property<uint16_t>  aud_dur_ms;     // the auditory cue duration.
    
    Property<uint16_t>  aud_tick_hz;    // the frequency of auditory cue flickering.
    
    Property<uint16_t>  resp_dur_ms;    // the size of the minimal 'response window' for the passive paradigms.
    
    Property<uint16_t>  post_dur_ms;    // the post-reward recording duration.
    
    Property<uint16_t>  reward_dur_ms;  // the duration of reward.
    
    Property<uint16_t>  onset_min_ms;   // the minimum onset for the (passive) visual cue during the Associate mode.
    
    Property<uint16_t>  onset_steps_n;  // the number of steps in the onset during the Associate mode.
    
    Property<uint16_t>  vis_dur_ms;     // the duration for the (passive) visual cue.
    
    Property<uint16_t>  vis_test_every;     // the frequency of 'test' trials during the Pair/Report modes.
    
    Property<uint16_t>  whisk_debounce_ms;  // the debounce period for whisking events.
    
    Property<uint16_t>  lick_debounce_ms;   // the debouncing period for licking events.
    
    Action              test_reward;
    
    Action              clear_index;
    
    Action              run;
    
    explicit Task(const Mode& mode=Pair);
    
    void parseFromSerial();
    
private:
    void testReward();
    void clearTrialIndex();
    void runTrial();
    void writeSettingsToSerial();
};
#endif