#ifndef STATES_H_
#define STATES_H_

#include "mbed.h"

struct Delay {
    static void setup();
    static void teardown();
};

/**
*   lick is not allowed during this period.
*   if the animal licks, the state transits to Abort.
*/
struct Prepare {
    static void setup();
    static void teardown();
};

/**
*   comes to this state in response to a too early licking
*   (e.g. during Prepare period).
*   goes to the end of the trial without a reward delivery.
*/
struct Abort {
    static void setup();
    static void teardown();
};

/**
*   used during the Stage/Associate/Motion mode.
*   the auditory cue is delivered here.
*/
struct Staged {
    static void setup();
    static void logCatch();
    static void teardown();
};

/**
*   used only for the Pair mode.
*   except for during the 'testing' trial, reward is delivered unconditionally.
*/
struct Paired {
    static void setup();
    static void teardown();
};

/**
*   comes to this state during the Pair mode if the mouse licks before the 
*   end of the visual stimulus.
*   the reward is delivered in response.
*/
struct Hit {
    static void setup();
    static void teardown();
};

/**
*   post-reward monitoring period for the Pair mode.
*/
struct Monitored {
    static void setup();
    static void teardown();
};

/**
*   used to present reward-related conditioning cue(s) (visual, auditory).
*   necessary whisk/lick/stimulus-related callbacks are also used.
*/
struct Cued {
    static void setup();
    static void gate();
    static void teardown();
};

/**
*   if the animal licked during Paired/Cued/Monitor period, the automaton transits to this state.
*   unless it is in the Paired mode, reward is delivered here.
*/
struct WithResp {
    static void setup();
    static void teardown();
};

struct NoResp {
    static void setup();
    static void teardown();
};

struct TestReward {
    static void setup();
    static void teardown();
};

struct ClearTrialIndex {
    static void setup();
    static void teardown();
};

#endif