#ifndef RIG_H_
#define RIG_H_

#include "mbed.h"

#include "pulse.h"
#include "intr.h"

#include "task.h"
#include "trial.h"

const uint16_t TRIGGER_DUR_MS = 2; // duration of trialStart/trialEnd pulses, in milliseconds

// input
extern InterruptHandler  gateIn;
extern InterruptHandler  whiskIn;
extern InterruptHandler  lickIn;

// output
extern Pulse        audioOut;
extern Pulse        visualOut;
extern Pulse        rewardOut;

extern Pulse        trialStart;
extern Pulse        trialEnd;

extern Task        task;
extern Trial       trial;

#endif