#ifndef UTILS_H_
#define UTILS_H_
#include <string>
#include "IO.h"

inline bool isWhitespace(const char& ch) {
    return  (ch == ' ') ||
            (ch == '\t') ||
            (ch == '\r') ||
            (ch == '\n') ||
            (ch == '\v') ||
            (ch == '\f');
}

inline us_timestamp_t ms_to_us(const uint16_t& ms)
{
    return ((us_timestamp_t)ms)*1000;
}

inline std::string uint64_to_str(uint64_t value, const uint16_t& base=10)
{
      std::string result;

      do {
            char c = value % base;
            value /= base;
        
            if (c < 10)
              c +='0';
            else
              c += 'A' - 10;
            result = c + result;
      } while (value);
      return result;
}

template <typename V>
V parseUnsignedFromSerial(const V& defaultvalue)
{
  V value = 0;
  while(true) {
    
    int readChar = IO::getc();

    // only accepts digits
    if ((readChar >= 48) && (readChar <= 57)) {
      value = value * 10 + (readChar - 48);
      // continues parsing
      
    } else if ( isWhitespace((char)readChar) || (readChar == 59) ) {
      // space or ';'
      // ends parsing
      break;
      
    } else {
      IO::error("%c",(char)readChar);
      // set value back to original
      value = defaultvalue;
      break;
      
    }
  }
  
  return value;
}
#endif