#include "scheduler.h"
#include "IO.h"

namespace scheduler
{
    Timeout timeout_;
    
    void set(const us_timestamp_t& timeout_us, Callback<void ()> func)
    {
        if (timeout_us == 0) {
            func();
        } else {
            timeout_.detach();
            timeout_.attach_us(func, timeout_us);
        }
    }
    
    void reset()
    {
        timeout_.detach();
    }
}