#include "random.h"
#include "mbed.h"
#include <limits.h>

namespace random
{       
    AnalogIn noise(RANDOM_NOISE_PIN);
    bool initialized = false;
    
    void init() {
        srand(((uint32_t)noise.read_u16())<<16 & ((uint32_t)noise.read_u16()));
        initialized = true;
    }
    
    uint32_t unif(const uint32_t& nlevels) {
        if (!initialized) {
            init();
        }
        return ((uint32_t)rand()) % nlevels;
    }
    
    uint32_t exponential(const uint32_t& tau, const uint32_t& cutoff, const unsigned int& resolution){
        if (!initialized) {
            init();
        }
        
        double ftau     = (double)tau;
        double fcutoff  = (double)cutoff;
        double cumulativeFraction = ((double)(rand() & resolution))/resolution;
        
        // calculate the point (in exponential distribution) from the inverse of its cumulative density function
        double point = -ftau * log(1-cumulativeFraction);
        
        // return as uint32 value.
        // if `point` is unreasonably long, then return `cutoff` instead.
        if (point > fcutoff) {
            return cutoff;
        } else {
            return (uint32_t)(point+0.5);
        }
    }
}
