#ifndef INTR_H_
#define INTR_H_

#include "mbed.h"
#include "arraylist.h"
#include "trialtime.h"
#include "IO.h"

class InterruptHandler
{
public:
    explicit InterruptHandler(PinName pin, const int& debounce_ms=-1, const bool& logged=true);
    
    void attach(Callback<void ()> cb);
    void detach();
    void setDebounce(const int& value_ms);
    void reset(const int& debounce_ms=-1, const bool& logged=true);
    void writeToSerial(const trialtime_t& origin=0);

private:
    void trigger();

    InterruptIn         in_;
    bool                logged_;
    int                 debounce_;
    Callback<void ()>   handler_;
    
    trialtime_t             refrac_;
    ArrayList<trialtime_t>  events_;
};

#endif
