#include "intr.h"

InterruptHandler::InterruptHandler(PinName pin, const int& debounce_ms, const bool& logged):
    in_(pin), logged_(logged)
{
    in_.rise(callback(this, &InterruptHandler::trigger));
    setDebounce(debounce_ms);
}

void InterruptHandler::trigger()
{
    trialtime_t stamp_ms = TrialTimer.read_ms();
    if (stamp_ms < refrac_) {
        return;
    }
    
    if (logged_) {
        events_.add(stamp_ms);
    }
    if (handler_) {
        handler_();
    }
    refrac_ = stamp_ms + debounce_;
}

void InterruptHandler::attach(Callback<void ()> cb)
{
    handler_ = cb;
}

void InterruptHandler::detach()
{
    handler_ = 0;
}

void InterruptHandler::setDebounce(const int& value_ms)
{
    debounce_   = value_ms;
    refrac_     = value_ms;
}

void InterruptHandler::reset(const int& debounce_ms, const bool& logged)
{
    setDebounce(debounce_ms);
    events_.clear();
    logged_ = logged;
}

void InterruptHandler::writeToSerial(const trialtime_t& origin)
{
    events_.writeToSerial(origin);
}
    