#ifndef AUTOMATON_H_
#define AUTOMATON_H_

#include "mbed.h"

namespace automaton
{
    
    /**
    *   event enum to notice changes to the instance
    */
    enum Event
    {
        None        = 0x00,
        Transition  = 0x01,
        Done        = 0x02,
    };
    
    /**
     * a callback that does nothing
     */
    void do_nothing_callback();
    
    extern Callback<void()> entry;
    extern Callback<void()> teardown_prev;
    extern Callback<void()> setup_next;
    extern volatile Event      event;
    
    /**
    *   marks for performing a transition from FromState to ToState.
    */
    template<typename FromState, typename ToState>
    void jump()
    {
        if ( event == None ){
            teardown_prev = &FromState::teardown;
            setup_next    = &ToState::setup;
            event = Transition;
        }
    }
    
    template<typename State>
    void done()
    {
        if (event == None){
            teardown_prev = &State::teardown;
            setup_next    = &do_nothing_callback;
            event = Done;
        }
    }
    
    template<typename State>
    void init()
    {
        entry           = &State::setup;
        teardown_prev   = &do_nothing_callback;
        setup_next      = &do_nothing_callback;
        event           = None;
    }

    /**
    *   runs the automaton once
    */
    void run();
    
}
#endif
