#include "automaton.h"

//#define DEBUG_AUTOMATON

#ifdef DEBUG_AUTOMATON
#include "IO.h"
#define LOG_DEBUG(msg) IO::debug(msg)
#else
#define LOG_DEBUG(msg)
#endif

namespace automaton {
    
    Callback<void()> entry;
    Callback<void()> teardown_prev;
    Callback<void()> setup_next;
    volatile Event      event;
    
    void makeTransition();
    
    void empty_entry_callback()
    {
        event = Done;
    }
    
    void do_nothing_callback(){  } // do nothing
    
    void run(){
        event = None;
        
        // go into the entry point
        LOG_DEBUG("starting");
        entry();
        
        while(event != Done){
            // wait until event status changes
            while(event == None);
            
            switch(event){
            case Transition:
                makeTransition();
                break;
            case Done:
                break;
            default:
                // TODO: handle error more nicely
                LOG_DEBUG("unexpected event");
                event = Done;
                break;
            }
        }
        
        // cleaning up the last state
        teardown_prev();
        
        // pc.printf("done.\r\n");
    }
    
    void makeTransition()
    {
        LOG_DEBUG("transition");
        teardown_prev();
        setup_next();
        event = None;
    }
}
