#ifndef ARRAYLIST_H_
#define ARRAYLIST_H_

#include "mbed.h"
#include "IO.h"

#define ARRAY_BUFFER_SIZE 256

template <typename T>
class ArrayList
{
public:
    ArrayList(): offset(0) { }
    
    void add(const T& item) {
        array[offset++] = item;
        if (offset == ARRAY_BUFFER_SIZE) {
            offset = 0;
        }
    }
    
    void clear() {
        offset = 0;
    }
    
    void writeToSerial(const T& origin=0) {
        IO::write('[');
        for (int i=0; i<offset; i++) {
            IO::write("%d,",array[i] - origin);
        }
        IO::write(']');
    }
private:
    int     offset;
    T       array[ARRAY_BUFFER_SIZE];
};

#endif