#ifndef IO_H_
#define IO_H_

#include "mbed.h"
#define LOGGER_BAUDRATE 9600

#define STR_DELIMITER     ";"
#define STR_NEWLINE       "\r\n"

namespace IO {
    
    const char CONFIG_HEADER = '@';
    const char INFO_HEADER   = '>';
    const char RESULT_HEADER = '+';
    const char ERROR_HEADER  = '*';
    const char DEBUG_HEADER  = '.';
    
    int getc();
    void config(const char *fmt,...);
    void info(const char *fmt,...);
    void result(const char *fmt,...);
    void error(const char *fmt,...);
    void debug(const char *fmt,...);
    void write(const char *fmt,...);
    void write(const char& c);
}

#endif