#include "IO.h"
#define NEWLINE "\r\n"

namespace IO {
    Serial conn(USBTX, USBRX, LOGGER_BAUDRATE);
    
    int getc() {
        return conn.getc();
    }
    
    void config(const char *fmt,...) {
        std::va_list args;
        va_start(args, fmt);
        conn.putc(CONFIG_HEADER);
        conn.vprintf(fmt, args);
        va_end(args);
        conn.printf(NEWLINE);
    }
    
    void info(const char *fmt, ...) {
        std::va_list args;
        va_start(args, fmt);
        conn.putc(INFO_HEADER);
        conn.vprintf(fmt, args);
        va_end(args);
        conn.printf(NEWLINE);
    }
    
    void result(const char *fmt, ...) {
        std::va_list args;
        va_start(args, fmt);
        conn.putc(RESULT_HEADER);
        conn.vprintf(fmt, args);
        va_end(args);
        conn.printf(NEWLINE);
    }
    
    void error(const char *fmt, ...) {
        std::va_list args;
        va_start(args, fmt);
        conn.putc(ERROR_HEADER);
        conn.vprintf(fmt, args);
        va_end(args);
        conn.printf(NEWLINE);
    }
    
    void debug(const char *fmt, ...) {
        std::va_list args;
        va_start(args, fmt);
        conn.putc(DEBUG_HEADER);
        conn.vprintf(fmt, args);
        va_end(args);
        conn.printf(NEWLINE);
    }
    
    void write(const char *fmt, ...) {
        std::va_list args;
        va_start(args, fmt);
        conn.vprintf(fmt, args);
        va_end(args);
    }
    
    void write(const char& c) {
        conn.putc(c);
    }
}