//---------------------------------------------------------------------//
//                             Defines                                 //
//---------------------------------------------------------------------//
#include "mbed.h"
#include "header.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
PwmOut PWMSetup(p24);

//---------------------------------------------------------------------//
//                             Variables                               //
//---------------------------------------------------------------------//
int i=0,ms_counter=0;
char getkey;
extern float InputLightLevel;  // in dBm
extern float OutputLightLevel;  // in dBm
extern float ReflectedLightLevel;  // in dBm
extern float PumpLightLevel1;  // in dBm
extern float PumpLightLevel2; // in dBm
extern float InputLightLevelM;
extern float OutputLightLevelM;
extern float ReflectedLightLevelM;
extern float PumpLightLevel1M;
extern float PumpLightLevel2M;
extern float AmplifierGain; //in dB
extern float AmplifierPower; //in dBm
extern char  AmplifierMode; // C = Constant Current, G = Constant Gain, P = constant output power
extern float PumpCurrent1; // mA
extern float PumpCurrent2; // mA
extern char SerialControl;
extern int DebugLevel;
extern char commandstring[16];
extern char commandstringlen;

//---------------------------------------------------------------------//
//                             Functions                               //
//---------------------------------------------------------------------//

Serial pc(USBTX, USBRX); // tx, rxSerial pc(USBTX, USBRX); // tx, rx
Ticker timer;

void SerialBuffer(void)
{
     if(pc.readable())
     {
        getkey=pc.getc();            
        commandstring[i] = getkey;
        i++;        
     }
     if ((i>=15)||(getkey==0x0d)||(getkey=='.')||(getkey=='>')||(getkey==',')||(getkey=='<')||(getkey=='p')||(getkey=='P')||(getkey=='[')||(getkey==']')||(getkey=='*')||(getkey=='s')||(getkey=='?'))         
     {
        getkey=0;
        led2=1;
        commandline();
        led2=0;
        i = 0;
     }
     
}
void Tick() {

    ReadADCValues();
    ControlLoop();
    WritePWMValues();
    //SerialBuffer();
   
     ms_counter++;
     if (ms_counter>=1000) ms_counter=0;
     if (ms_counter>500) led1 = 1; else led1 = 0; // show we are still alive
}
void Initialise(void)
{
     ReadConfigFile();
     timer.attach_us(&Tick, 1000);
     PWMSetup.period_us(1000);
}
//---------------------------------------------------------------------//
//                             Main                                    //
//---------------------------------------------------------------------//


int main() {

    pc.baud(57600);
    splashscreen(); 
    wait_ms(200);
    Initialise();


    while(1)
    {
    waitforcommand();

    }
    
}