#include "mbed.h"
#include "header.h"

AnalogIn RLL(p15);
AnalogIn SLL(p16);
AnalogIn ReflLL(p17);
AnalogIn Pump1LL(p18);
AnalogIn Pump2LL(p19);
AnalogIn SupyLL(p20);

PwmOut PUMP1_DRV(p24);
PwmOut PUMP2_DRV(p23);


extern float InputLightLevel;  // in dBm
extern float OutputLightLevel;  // in dBm
extern float ReflectedLightLevel;  // in dBm
extern float PumpLightLevel1;  // in dBm
extern float PumpLightLevel2; // in dBm
extern float InputLightLevelM;
extern float OutputLightLevelM;
extern float ReflectedLightLevelM;
extern float PumpLightLevel1M;
extern float PumpLightLevel2M;
extern float AmplifierGain; //in dB
extern float AmplifierMode; // CC = Constant Current, CG = Constant Gain, CP = constant output power
extern float PumpCurrent1; // mA
extern float PumpCurrent2; // mA
extern float CurrentSource1MAX; 
extern float CurrentSource2MAX; 

void ReadADCValues(void)
{
    InputLightLevel = 10.0*log10(RLL*InputLightLevelM);
    OutputLightLevel = 10.0*log10(SLL*OutputLightLevelM);
    ReflectedLightLevelM = 10.0*log10(ReflLL*ReflectedLightLevel);
    PumpLightLevel1 = 10.0*log10(Pump1LL*PumpLightLevel1M);
    PumpLightLevel2 = 10.0*log10(Pump2LL*PumpLightLevel2M);

}
void WritePWMValues(void)
{
   PUMP1_DRV = PumpCurrent1/CurrentSource1MAX;
   PUMP2_DRV = PumpCurrent2/CurrentSource2MAX;
}
