
#include "mbed.h"
#include <string.h>
#include "header.h"


extern float InputLightLevel;  // in dBm
extern float OutputLightLevel;  // in dBm
extern float ReflectedLightLevel;  // in dBm
extern float PumpLightLevel1;  // in dBm
extern float PumpLightLevel2; // in dBm
extern float InputLightLevelM;
extern float OutputLightLevelM;
extern float ReflectedLightLevelM;
extern float PumpLightLevel1M;
extern float PumpLightLevel2M;
extern float AmplifierGain; //in dB
extern float AmplifierPower; //in dBm
extern char  AmplifierMode; // CC = Constant Current, CG = Constant Gain, CP = constant output power
extern float PumpCurrent1; // mA
extern float PumpCurrent2; // mA
extern int DebugLevel;

void CheckLimits(void)
{
    if (InputLightLevel<-30.0) InputLightLevel=-30.0;
    if (InputLightLevel>30.0) InputLightLevel=30.0;
    if (OutputLightLevel<-30.0) OutputLightLevel=-30.0;
    if (OutputLightLevel>30.0) OutputLightLevel=30.0;
    if (ReflectedLightLevel<-30.0) ReflectedLightLevel=-30.0;
    if (ReflectedLightLevel>30.0) ReflectedLightLevel=30.0;
    if (PumpLightLevel1<-30.0) PumpLightLevel1=-30.0;
    if (PumpLightLevel1>30.0) PumpLightLevel1=30.0;
    if (PumpLightLevel2<-30.0) PumpLightLevel2=-30.0;
    if (PumpLightLevel2>30.0) PumpLightLevel2=30.0;
    if (AmplifierGain<0.0) AmplifierGain=0.0;
    if (AmplifierGain>30.0) AmplifierGain=30.0;
    if (AmplifierPower<-30.0) AmplifierPower=-30.0;
    if (AmplifierPower>30.0) AmplifierPower=30.0;
    if (PumpCurrent1<0.0) PumpCurrent1=0.0;
    if (PumpCurrent1>600.0) PumpCurrent1=600.0;
    if (PumpCurrent2<0.0) PumpCurrent2=0.0;
    if (PumpCurrent2>600.0) PumpCurrent2=600.0;

}
void ControlLoop(void)
{
    CheckLimits();   
}
