#include "ConfigFile.h"
#include "mbed.h"
#include <string.h>
#include "header.h"
extern float InputLightLevelM;
extern float OutputLightLevelM;
extern float ReflectedLightLevelM;
extern float PumpLightLevel1M;
extern float PumpLightLevel2M;
extern float AmplifierGain; //in dB
extern float AmplifierPower; //in dBm
extern char  AmplifierMode; // CC = Constant Current, CG = Constant Gain, CP = constant output power
extern float PumpCurrent1; // mA
extern float PumpCurrent2; // mA
extern float CurrentSource1MAX; 
extern float CurrentSource2MAX; 
extern char SerialControl;
extern int DebugLevel;
LocalFileSystem local("local");
ConfigFile cfg;

void ReadConfigFile(void) {
    char *cfg1 = "DebugLevel";
    char *cfg2 = "InputLightLevelM";
    char *cfg3 = "OutputLightLevelM";
    char *cfg4 = "ReflectedLightLevelM";
    char *cfg5 = "PumpLightLevel1M";
    char *cfg6 = "PumpLightLevel2M";
    char *cfg7 = "DefaultAmplifierGain";
    char *cfg8 = "DefaultAmplifierPower";
    char *cfg9 = "DefaultAmplifierMode";
    char *cfg10 = "DefaultPumpCurrent1";
    char *cfg11 = "DefaultPumpCurrent2";
    char *cfg12 = "CurrentSource1MAX";
    char *cfg13 = "CurrentSource2MAX";
    char *cfg14 = "SerialControl";
    char value[BUFSIZ];
    /*
     * Read a configuration file from a mbed.
     */
      printf("\n\rReading Config File:\n\r");
    if (!cfg.read("/local/config.txt")) {
        printf("Failure to read a configuration file.\n");
    }

    /*
     * Get a configuration value.
     */
    if (cfg.getValue(cfg1, &value[0], sizeof(value))) {
        printf("%s = %i\n\r", cfg1, atoi(value));
        DebugLevel = atoi(value);
    }
    if (cfg.getValue(cfg2, &value[0], sizeof(value))) {
        printf("%s = %3.4f\n\r", cfg2, atof(value));
        InputLightLevelM = atof(value);
    }
  if (cfg.getValue(cfg3, &value[0], sizeof(value))) {
        printf("%s = %3.4f\n\r", cfg3, atof(value));
        OutputLightLevelM = atof(value);
    }
  if (cfg.getValue(cfg4, &value[0], sizeof(value))) {
        printf("%s = %3.4f\n\r", cfg4, atof(value));
        ReflectedLightLevelM = atof(value);
    }
  if (cfg.getValue(cfg5, &value[0], sizeof(value))) {
        printf("%s = %3.4f\n\r", cfg5, atof(value));
        PumpLightLevel1M = atof(value);
    }
  if (cfg.getValue(cfg6, &value[0], sizeof(value))) {
        printf("%s = %3.4f\n\r", cfg6, atof(value));
        PumpLightLevel2M = atof(value);
    }
  if (cfg.getValue(cfg7, &value[0], sizeof(value))) {
        printf("%s = %3.4f\n\r", cfg7, atof(value));
        AmplifierGain = atof(value);
    }
  if (cfg.getValue(cfg8, &value[0], sizeof(value))) {
        printf("%s = %3.4f\n\r", cfg8, atof(value));
        AmplifierPower = atof(value);
    }
  if (cfg.getValue(cfg9, &value[0], sizeof(value))) {
        printf("%s = %s\n\r", cfg9, value);
        AmplifierMode = value[1];
    }
  if (cfg.getValue(cfg10, &value[0], sizeof(value))) {
        printf("%s = %3.4f\n\r", cfg10, atof(value));
        PumpCurrent1 = atof(value);
    }
  if (cfg.getValue(cfg11, &value[0], sizeof(value))) {
        printf("%s = %3.4f\n\r", cfg11, atof(value));
        PumpCurrent2 = atof(value);
    }     
  if (cfg.getValue(cfg12, &value[0], sizeof(value))) {
        printf("%s = %3.4f\n\r", cfg12, atof(value));
        CurrentSource1MAX = atof(value);
    }     
  if (cfg.getValue(cfg13, &value[0], sizeof(value))) {
        printf("%s = %3.4f\n\r", cfg13, atof(value));
        CurrentSource2MAX = atof(value);
    }     
  if (cfg.getValue(cfg14, &value[0], sizeof(value))) {
        printf("%s = %c\n\r", cfg14, value[0]);
        SerialControl = value[0];
    }     
    
    
      printf("\n\r\n\r>");
  
}

