
#include "mbed.h"
#include <string.h>
#include "header.h"
#include "SerialRPCInterface.h"


extern float InputLightLevel;  // in dBm
extern float OutputLightLevel;  // in dBm
extern float ReflectedLightLevel;  // in dBm
extern float PumpLightLevel1;  // in dBm
extern float PumpLightLevel2; // in dBm
extern float InputLightLevelM;
extern float OutputLightLevelM;
extern float ReflectedLightLevelM;
extern float PumpLightLevel1M;
extern float PumpLightLevel2M;
extern float AmplifierGain; //in dB
extern float AmplifierPower; //in dBm
extern char  AmplifierMode; // C = Constant Current, G = Constant Gain, P = constant output power
extern float PumpCurrent1; // mA
extern float PumpCurrent2; // mA
extern char SerialControl;
extern int DebugLevel;

extern char commandstring[16];
extern char commandstringlen;
extern "C" void mbed_reset();




void splashscreen();
void commandline(void)
{
    long int templi=0;
    
   
    //pc.scanf("%s",&commandstring);
  
    if (commandstring[0] == '*')
    {
         printf("Resetting...\n\r");
         wait_ms(1000);
         mbed_reset(); 
    }
    if (commandstring[0] == 's')
    {
         splashscreen();
        statusscreen();
    }
    if (commandstring[0] == 'd')
        {
        if (commandstring[1]<97)
        {
            templi = (commandstring[1]-48)*0x10;
        }else
        {
            templi = (commandstring[1]-97+10)*0x10;
        }
        if (commandstring[2]<97)
        {
            templi += (commandstring[2]-48);
        }else
        {
            templi += (commandstring[2]-97+10);
        }
        printf ("\n\rDAC(%X)\n\r", templi);
        
    }
 
    
    if (commandstring[0] == '.')
    {
        switch (AmplifierMode)
        {
        case 'c':
        case 'C':
            PumpCurrent1+=1.0;
            PumpCurrent2+=1.0;
            printf ("\n\rPumpCurrent1 %3.1f mA\n\r", PumpCurrent1);
            printf ("\n\rPumpCurrent2 %3.1f mA\n\r", PumpCurrent2);
            break;
        case 'g':
        case 'G':
            AmplifierGain+=0.1;
            printf ("\n\rAmplifierGain %3.1f dBm\n\r", AmplifierGain);
            break;
        case 'p':
        case 'P':
            AmplifierPower+=0.1;
            printf ("\n\rAmplifierPower %3.1f dBm\n\r", AmplifierPower);
            break;        
        }
    }
                            
    if (commandstring[0] == ',')
    {
        switch (AmplifierMode)
        {
        case 'c':
        case 'C':
            PumpCurrent1-=1.0;
            PumpCurrent2-=1.0;
            printf ("\n\rPumpCurrent1 %3.1f mA\n\r", PumpCurrent1);
            printf ("\n\rPumpCurrent2 %3.1f mA\n\r", PumpCurrent2);
            break;
        case 'g':
        case 'G':
            AmplifierGain-=0.1;
            printf ("\n\rAmplifierGain %3.1f dB\n\r", AmplifierGain);
            break;
        case 'p':
        case 'P':
            AmplifierPower-=0.1;
            printf ("\n\rAmplifierPower %3.1f dBm\n\r", AmplifierPower);
            break;        
        }
    }
    if (commandstring[0] == '<')
    {
        PumpCurrent1+=1.0;
        PumpCurrent2-=1.0;
        printf ("\n\rPumpCurrent1 %3.1f mA\n\r", PumpCurrent1);
        printf ("\n\rPumpCurrent2 %3.1f mA\n\r", PumpCurrent2);
    }
    if (commandstring[0] == '>')
    {
        PumpCurrent1-=1.0;
        PumpCurrent2+=1.0;
        printf ("\n\rPumpCurrent1 %3.1f mA\n\r", PumpCurrent1);
        printf ("\n\rPumpCurrent2 %3.1f mA\n\r", PumpCurrent2);
    }
    if ((commandstring[0] == 'c')||(commandstring[0] == 'C'))
    {
        if ((commandstring[1] == 'c')||(commandstring[1] == 'C')) {AmplifierMode='c'; printf("Amplifier Mode: CONST CURRENT");}
        if ((commandstring[1] == 'g')||(commandstring[1] == 'G')) {AmplifierMode='g'; printf("Amplifier Mode: CONST GAIN");}
        if ((commandstring[1] == 'p')||(commandstring[1] == 'P')) {AmplifierMode='p'; printf("Amplifier Mode: CONST POWER");}
        
  
    }
    if (commandstring[0] == 'r')
    {
        if (commandstring[1]<97)
        {
            templi = (commandstring[1]-48)*0x10;
        }else
        {
            templi = (commandstring[1]-97+10)*0x10;
        }
        if (commandstring[2]<97)
        {
            templi += (commandstring[2]-48);
        }else
        {
            templi += (commandstring[2]-97+10);
        }

         printf ("\n\r(%X) => \n\r", templi);
    }
    if ((commandstring[0] == 'w')&&(commandstringlen == 10))
    {
        if (commandstring[1]<97)
        {
            templi = long(commandstring[1]-48)*0x10000000;
        }else
        {
            templi = long(commandstring[1]-97+10)*0x10000000;
        }
        if (commandstring[2]<97)
        {
            templi += long(commandstring[2]-48)*0x1000000;
        }else
        {
            templi += long(commandstring[2]-97+10)*0x1000000;
        }
        if (commandstring[3]<97)
        {
            templi += long(commandstring[3]-48)*0x100000;
        }else
        {
            templi += long(commandstring[3]-97+10)*0x100000;
        }
        if (commandstring[4]<97)
        {
            templi += long(commandstring[4]-48)*0x10000;
        }else
        {
            templi += long(commandstring[4]-97+10)*0x10000;
        }
        if (commandstring[5]<97)
        {
            templi += long(commandstring[5]-48)*0x1000;
        }else
        {
            templi += long(commandstring[5]-97+10)*0x1000;
        }
        if (commandstring[6]<97)
        {
            templi += long(commandstring[6]-48)*0x100;
        }else
        {
            templi += long(commandstring[6]-97+10)*0x100;
        }
        if (commandstring[7]<97)
        {
            templi += long(commandstring[7]-48)*0x10;
        }else
        {
            templi += long(commandstring[7]-97+10)*0x10;
        }
        if (commandstring[8]<97)
        {
            templi += long(commandstring[8]-48);
        }else
        {
            templi += long(commandstring[8]-97+10);
        }
        printf ("\n\r(%X)\n\r", 0);
    }
    if (commandstring[0] == '?')
    {
        printf("\n\r");
        printf("|----------------------------------------------------------------------|\n\r");
        printf("|  Read command rxx<cr> => r-read xx-address                           |\n\r");
        printf("|  Write command wxxyyyyyy<cr> => r-read xx-address yyy-data           |\n\r");
        printf("|  Set DAC command dxx<cr> => d-write to DAC xxx-data                  |\n\r");
        printf("|  Set Amplifier mode cx<cr> => x=c,g or p (Const current,gain,power)  |\n\r");  
        printf("|                                                                      |\n\r");  
        printf("|  Status  command:    s                                               |\n\r");
        printf("|  Manual Contol:      ,  Negative step                                |\n\r");    
        printf("|  Manual Contol:      .  Positive step                                |\n\r");          
        printf("|  Pump Balance adjust:<  Negative step                                |\n\r");    
        printf("|  Pump Balance adjust:>  Positive step                                |\n\r");    
        printf("|  RESET Controller:   *                                               |\n\r");  
        printf("|----------------------------------------------------------------------|\n\r");
    }
  printf("\r\n>");
  
}
void statusscreen(void)
{
         printf ("\n\rStatus\n\r");
         printf("SystemCoreClock      = %.3f MHz\n\r", (float)SystemCoreClock/1000000.0);
         printf("InputLightLevel      = %3.1f dBm\n\r", InputLightLevel);
         printf("OutputLightLevel     = %3.1f dBm\n\r", OutputLightLevel);
         printf("ReflectedLightLevel  = %3.1f dBm\n\r", ReflectedLightLevel);
         printf("PumpLightLevel1      = %3.1f dBm\n\r", PumpLightLevel1);
         printf("PumpLightLevel2      = %3.1f dBm\n\r", PumpLightLevel2);
        switch (AmplifierMode)
        {
        case 'c':
        case 'C':
         printf("Pump Mode            = CONSTANT CURRENT\n\r");
            break;
        case 'g':
        case 'G':
         printf("Pump Mode            = CONSTANT GAIN\n\r");
            break;
        case 'p':
        case 'P':
         printf("Pump Mode            = CONSTANT POWER\n\r");
            break; 
        }       
         printf("AmplifierGain        = %3.1f dBm\n\r", AmplifierGain);
         printf("PumpCurrent1         = %3.1f mA\n\r", PumpCurrent1);
         printf("PumpCurrent2         = %3.1f mA\n\r", PumpCurrent2);
         printf("\n\r>");   
  
}
void splashscreen(void)
{
    printf("%c",0x0C);
    printf("\r\nXtera Amplifier controller Debug Interface v0.01\n\n\r"); 
    printf("Type ?<cr> for help\n\n\r");
}

