#ifndef AD5235_H
#define AD5235_H
 
#include "mbed.h"
//Data Sheet http://www.analog.com/media/en/technical-documentation/data-sheets/AD5235.pdf

//Control Registers
#define CMD_NOP 0x00 //0- Do nothing
    //EEMEM No.-Address-----EEMEM Content for …
    //1         0000        RDAC1
    //2         0001        RDAC2
    //3         0010        USER1
    //4         0011        USER2
    //…         …           …
    //15        1110        USER13
    //16        1111        RAB1 tolerance

    //Instruction 3 writes two data bytes (16 bits of data) to EEMEM.
    //In the case of Address 0 and Address 1, only the last 10 bits
    //are valid for wiper position setting.
    //Basicaly it is CMD_USER2MEM + User mem address + user = B0011A3A2A1A0 + user
    //  A3  A2  A1  A0  
    //  0   0   0   0   RDAC1
    //  0   0   0   1   RDAC2
    //  1   1   1   1   Tolerance   Read Only

class AD5235 {
    SPI& spi;
    DigitalOut cs;    
public:
    AD5235(SPI& _spi, PinName _cs);
    void storeEEMEM2RDAC(uint8_t w);//1 - Restore EEMEM (A0) contents to RDAC (A0) register. See Table 16.
    void storeRDAC2EEMEM(uint8_t w);//2 - Store wiper setting. Store RDAC (A0) setting to EEMEM (A0). See Table 15. - Use a delay of 50ms!!!
    void setEEMEM(uint8_t w, uint16_t v);//3 - Store contents of Serial Register Data Byte 0 and Serial Register Data Bytes 1 (total 16 bits) to EEMEM (ADDR). See Table 18.- Use a delay of 50ms!!!/RDAC1 is 0, RDAC2 is 1, User1 is 2....User13 is 14
    void stepDown6Db(uint8_t w);//4 - Decrement by 6 dB. Right-shift contents of RDAC (A0) register, stop at all 0s.
    void stepDownAll6Db(void);//5 - Decrement all by 6 dB. Right-shift contents of all RDAC registers, stop at all 0s.
    void stepDown1(uint8_t w);//6 - Decrement contents of RDAC (A0) by 1, stop at all 0s.
    void stepDown1All(void);//7 - Decrement contents of all RDAC registers by 1, stop at all 0s.
    void refreshAllRDAC(void);//8 - Reset. Refresh all RDACs with their corresponding EEMEM previously stored values. - Use a delay of 30us!!!
    uint16_t getEEMEM(uint8_t w);//9 - Read contents of EEMEM (ADDR) from SDO output in the next frame. See Table 19. - Use a delay of 30us!!!
    uint16_t getWiper(uint8_t w);//10 - Read RDAC wiper setting from SDO output in the next frame. See Table 20. - Use a delay of 30us!!!
    void setWiper(uint8_t w, uint16_t v);//11 - Write contents of Serial Register Data Byte 0 and Serial Register Data Byte 1 (total 10 bits) to RDAC (A0). See Table 14.
    void stepUp6Db(uint8_t w);//12 - Increment by 6 dB: Left-shift contents of RDAC (A0),stop at all 1s. See Table 17.
    void stepUpAll6Db(void);//13 - Increment all by 6 dB. Left-shift contents of all RDAC registers, stop at all 1s.
    void stepUp1(uint8_t w);//14 - Increment contents of RDAC (A0) by 1, stop at all 1s. See Table 15.
    void stepUp1All(void);//15 - Increment contents of all RDAC registers by 1, stop at all 1s.
    void repeatCMD(void);//16 - See page 21 in manual Another subtle feature of the AD5235 is that a subsequent CS strobe, withoutclock and data, repeats a previous command
    float getTolerance(void);
private:  
uint16_t _reply;
PinName _CS_pin;
uint16_t transferData(uint8_t cmd, uint16_t val);
};
#endif