#include <mbed.h>
#include "AD5235.h"
 
AD5235::AD5235(SPI& _spi, PinName _cs) : spi(_spi), cs(_cs)
{
    spi.format(8,0);
    spi.frequency(1000000);
}
 

//1 - Restore EEMEM (A0) contents to RDAC (A0) register. See Table 16.
void AD5235::storeEEMEM2RDAC(uint8_t w)
{
    transferData(0x10 + w,  CMD_NOP);
} 
//2 - Store wiper setting. Store RDAC (A0) setting to EEMEM (A0). See Table 15. - Use a delay of 50ms!!!
void AD5235::storeRDAC2EEMEM(uint8_t w)
{
    transferData(0x20 + w,  CMD_NOP);
}
//3 - Store contents of Serial Register Data Byte 0 and Serial Register Data Bytes 1 (total 16 bits) to EEMEM (ADDR). See Table 18.
//Use a delay of 50ms!!!/RDAC1 is 0, RDAC2 is 1, User1 is 2....User13 is 14 
void AD5235::setEEMEM(uint8_t w, uint16_t v)
{
    transferData(0x30 + w, v);
} 
//4 - Decrement by 6 dB. Right-shift contents of RDAC (A0) register, stop at all 0s.
void AD5235::stepDown6Db(uint8_t w)
{
    transferData(0x40 + w,  CMD_NOP);
} 
//5 - Decrement all by 6 dB. Right-shift contents of all RDAC registers, stop at all 0s.
void AD5235::stepDownAll6Db(void)
{
    transferData(0x50 , CMD_NOP);
} 
//6 - Decrement contents of RDAC (A0) by 1, stop at all 0s.
void AD5235::stepDown1(uint8_t w)
{
    transferData(0x60 + w, CMD_NOP);
} 
//7 - Decrement contents of all RDAC registers by 1, stop at all 0s.
void AD5235::stepDown1All(void)
{
    transferData(0x70, CMD_NOP);
}
//8 - Reset. Refresh all RDACs with their corresponding EEMEM previously stored values. - Use a delay of 30us!!!
void AD5235::refreshAllRDAC(void)
{
    transferData(0x80, CMD_NOP);
}
//9 - Read contents of EEMEM (ADDR) from SDO output in the next frame. See Table 19. - Use a delay of 30us!!!
uint16_t AD5235::getEEMEM(uint8_t w)
{
    transferData(0x90 + w, CMD_NOP);
    wait_us(30);
    return transferData(CMD_NOP, CMD_NOP);
}
//10 - Read RDAC wiper setting from SDO output in the next frame. See Table 20. - Use a delay of 30us!!!
uint16_t AD5235::getWiper(uint8_t w)
{
    transferData(0xA0 + w, CMD_NOP);
    wait_us(30);
    return transferData(CMD_NOP, CMD_NOP);
} 
//11 - Write contents of Serial Register Data Byte 0 and Serial Register Data Byte 1 (total 10 bits) to RDAC (A0). See Table 14.
void AD5235::setWiper(uint8_t w, uint16_t v)
{
    transferData(0xB0 + w, v);
} 
//12 - Increment by 6 dB: Left-shift contents of RDAC (A0),stop at all 1s. See Table 17.
void stepUp6Db(uint8_t w)
{
    //transferData(0xC0, CMD_NOP);
} 
//13 - Increment all by 6 dB. Left-shift contents of all RDAC registers, stop at all 1s.
void AD5235::stepUpAll6Db(void)
{
    transferData(0xD0, CMD_NOP);
} 
//14 - Increment contents of RDAC (A0) by 1, stop at all 1s. See Table 15.
void AD5235::stepUp1(uint8_t w)
{
    transferData(0xE0 + w, CMD_NOP);
}
//15 - Increment contents of all RDAC registers by 1, stop at all 1s.
 void AD5235::stepUp1All(void)
 {
    transferData(0xF0, CMD_NOP);
}
//16 - See page 21 in manual Another subtle feature of the AD5235 is that a subsequent CS strobe, without clock and data, repeats a previous command
void AD5235::repeatCMD(void)
{
    cs = 0;
    cs = 1;
}

float AD5235::getTolerance()
{
    float tol = getEEMEM(15);
    int8_t b_1 = ((uint16_t)tol >> 8);
    int8_t b_0 = ((uint16_t)tol & 0xFF);
    if(b_1 > 127) //check if first bit in b_1 is 1
        b_1 -= 128;
    else
        b_1 = -b_1;
    for(uint8_t p = 0; p < 8; p++)
    {
        if((b_0 >> p) & 1)//check if but in position p is 1
        {
            tol =(float)b_1 + (float)b_0/ (float)(2 << p);//add the decimal part of the tolerance
            break;
        }
    }
    return tol;
}

uint16_t AD5235::transferData(uint8_t cmd, uint16_t val)
{
    uint8_t bytes[1];
    cs = 0;
    bytes[0] = spi.write(cmd);
    bytes[0] = spi.write(val >> 8);
    bytes[1] = spi.write(val & 0xFF);
    cs = 1;
    return (uint16_t)(bytes[0] << 8) + bytes[1];
}