#include "mbed.h"
#include "VMA306.h"

#include "test_us.h"


void ft_print_value_US_front_to_pc(VMA306& ultra_sonic, Serial &pc)
{
    if (ultra_sonic.isUSBReady())     pc.printf ("\r us_front = %5.2lf -", ultra_sonic.readUSB());
}

void ft_print_value_US_left_to_pc(VMA306& ultra_sonic, Serial &pc)
{
    if (ultra_sonic.isUSGReady())     pc.printf (" us_left = %5.2lf -", ultra_sonic.readUSG());
}

void ft_print_value_US_right_to_pc(VMA306& ultra_sonic, Serial &pc)
{
    if (ultra_sonic.isUSDReady())     pc.printf (" us_right = %5.2lf -", ultra_sonic.readUSD());
}

void ft_print_all_values_US(VMA306 &ultra_sonic, Serial &pc)
{
    ft_print_value_US_left_to_pc(ultra_sonic, pc);
    ft_print_value_US_front_to_pc(ultra_sonic, pc);
    ft_print_value_US_right_to_pc(ultra_sonic, pc);
}