//Robo class implementation for controlling robotic arm
//Created 10/12/2011 by MLD 427

#include "robo.h"
#include "mbed.h"
robo::robo(PinName s, PinName b, PinName e, PinName w, PinName c){
    spin = new PwmOut(s);
    base = new PwmOut(b);
    elbow = new PwmOut(e);
    wrist = new PwmOut(w);
    claw = new PwmOut(c);
    spin->period_ms(20);
    base->period_ms(20);
    elbow->period_ms(20);
    wrist->period_ms(20);
    claw->period_ms(20);
}

void robo::write(float percent,int servo){
    if(percent > 100)
        percent = 1;
    if(percent<0)
        percent = 0;
        switch(servo){
            case(0):
                spin->pulsewidth_us(percent * 10 +1000);
            break;
            case(1):
                base->pulsewidth_us(percent * 10 +1000);
            break;
            case(2):
                elbow->pulsewidth_us(percent * 10 +1000);
            break;
            case(3):
                wrist->pulsewidth_us(percent * 10 +1000);
            break;
            case(4):
                claw->pulsewidth_us(percent * 10 +1000);
            break;
        }
     
}

void robo::writeSpin(float percent){
    write(percent,0);
}
void robo::writeBase(float percent){
    if(percent >50)
        percent = 50;
    write(percent,1);
    }
void robo::writeElbow(float percent){
    write(percent,2);
}
void robo::writeWrist(float percent){
    if(percent>60)
        percent = 60;
    write(percent,3);
}
void robo::writeClaw(float percent){
    write(percent,4);
}
void robo::turnCenter(){
    writeBase(50);
}

void robo::openClaw(){
    writeClaw(50);
}


