#include "mbed.h"


 struct timeval
{
 unsigned long long int  tv_sec;        /* Seconds. */
 unsigned long long int tv_usec;    /* Microseconds. */
};
void sync(void);
void getValue(void);
//void readTime(void);
//void SetupTimer1(void);
void SetupTimer0(void);
void Timer1_IRQHandler(void);
void Timer0_IRQHandler(void);

unsigned long long int atoi1(char *str);
void getTime(struct timeval *tv);
void SetupTimer1(struct timeval *tv);
void setTimeval(struct timeval *tv);
void runAtTime (void (*schedFunc)(), struct timeval *tv);
void schedFunc(void);
void pinToggle(void);

DigitalOut toggle(p18);
Serial device(p9, p10);
Serial command(p13, p14);
Serial pc(USBTX, USBRX);
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
char* store=new char;
int i=0;
int k=0;
int timeNum=0;
unsigned long long int t1=0;
unsigned long long int t2=0;
unsigned long long int t3=0;
unsigned long long int t4=0;
long long int t11=0;
long long int t22=0;
long long int t33=0;
long long int t44=0;
long long int offset;
char buffRx[100];
int handleTrue = 0;
int triggerTime;
timeval trigTime;

int main() {
wait(0.001);
   for(int i =0;i<100;i++){
     buffRx[i]=NULL;
   }
   timeval *currentTime = new timeval;
   triggerTime=5000;
      SetupTimer0();
      setTimeval(&trigTime);
      SetupTimer1(&trigTime);
      while(1){
        wait(2);
        sync(); 
      }
    

}
void pinToggle(void){
   toggle=!toggle;
}
void sync(void){
 char temp1[40];
 char temp2[40];
 int numcount=0;
 t1=(unsigned long long int)(LPC_TIM1->TC+4294967296*timeNum);
 device.putc('s');// send s to initialize synchronization.
 device.attach(&getValue);
 if(handleTrue == 1){
       
      handleTrue = 0;
      k=0;
    if(buffRx[0] == 'd'){
         t4=(unsigned long long int)(LPC_TIM1->TC+4294967296*timeNum);
        
    }
    for(int i=0; i<40;i++){
          temp1[i]=NULL;
          temp2[i]=NULL;
          }
    if(buffRx[1] == 'm'){
         for(int i=2;buffRx[i]!='f';i++){
             temp1[i-2]=buffRx[i];
             numcount = i;
         }
         t2=atoi1(temp1);

          for(int i=0; i<40;i++){
          temp1[i]=NULL;
          }
         for(int i=numcount+2;buffRx[i]!='n';i++){
             temp2[i-numcount-2]=buffRx[i];
         }
         numcount=0;
         t3=atoi1(temp2);
         for(int i=0; i<40;i++){
           temp2[i]=NULL;
         }
         t11=(long long int)t1;
         t22=(long long int)t2;
         t33=(long long int)t3;
         t44=(long long int)t4;
         offset = (long long int)(((t22-t11)-(t44-t33))/2);
       for(int i=0;buffRx[i]!=NULL;i++){
            buffRx[i]=NULL;
       }
    }
  }
     pc.printf("\r\nT1: %llu, T2: %llu, T3: %llu T4: %llu timeNum:%d\r\nOffset is %lld!\r\n",t1,t2,t3,t4, timeNum,offset);

}

void getValue(void){
 buffRx[k]=device.getc();
 if(buffRx[k]=='n'){
     handleTrue = 1;
 }
     k++;
}

void SetupTimer1(struct timeval *tv)
{
 LPC_SC->PCONP |= 1 << 2;     // Power on Timer`
 LPC_SC->PCLKSEL0 |= 1 << 4;
 LPC_TIM1->TCR = 0x2;         // Reset and set to timer mode
 LPC_TIM1->CTCR = 0x0;
 LPC_TIM1->PR = 0;            // No prescale
 LPC_TIM1->MR0 = 0xFFFFFFFF;        // count overflow
 LPC_TIM1->MR1=((tv->tv_usec-1)*96000+offset);         //trigger function at time in ms
 LPC_TIM1->MCR = 0x00000009;           // If there is interrupt trigger it
 LPC_TIM1->TCR = 1;           // Enable Timer
LPC_TIM1->IR = 1;
 // Enable the ISR vector
 NVIC_SetVector (TIMER1_IRQn, (uint32_t)&Timer1_IRQHandler);
 NVIC_EnableIRQ(TIMER1_IRQn);
}
void Timer1_IRQHandler(void)
{
 if((LPC_TIM1->IR|0xFFFFFFFE)==0xFFFFFFFF){//handle timer overflow
   myled1=!myled1;
    timeNum++;

    LPC_TIM1->IR = 1<<0;
 }

 if((LPC_TIM1->IR|0xFFFFFFFD)==0xFFFFFFFF){//trigger function at specific time
    runAtTime (schedFunc,&trigTime);
   
    LPC_TIM1->IR = 1<<1;
 }

}

void SetupTimer0(void)
{
 LPC_SC->PCONP |= 1 << 1;     // Power on Timer`0
 LPC_SC->PCLKSEL0 |= 1 << 2;
 LPC_TIM0->TCR = 0x2;         // Reset and set to timer mode
 LPC_TIM0->CTCR = 0x0;
 LPC_TIM0->PR = 0;            // No prescale
 
 LPC_TIM0->MR0 = 0x01000000;        // Match count for 2S
 LPC_TIM0->MCR = 3;           // Interrupt and Reset on Match
 LPC_TIM0->TCR = 1;           // Enable Timer

 // Enable the ISR vector
 NVIC_SetVector (TIMER0_IRQn, (uint32_t)&Timer0_IRQHandler);
 NVIC_EnableIRQ(TIMER0_IRQn);
}
void Timer0_IRQHandler(void)
{
 myled2=!myled2;
 //sync();
 LPC_TIM0->IR = 1;

}

void getTime(struct timeval *tv) {
     tv->tv_sec=(unsigned long long int)((LPC_TIM1->TC+4294967296*timeNum+offset)/96000000);
     tv->tv_usec=(unsigned long long int)((LPC_TIM1->TC+4294967296*timeNum+offset)/96000);
}

unsigned long long int atoi1(char *str){
   unsigned long long int result=0;
   for(int i =0;str[i]!=NULL;i++){
       int temp = str[i]-'0';
       result=result*10+temp;
   }
   return result;
}

void schedFunc(void){
   myled3=!myled3;
   pinToggle();
}

void runAtTime(void (*scheFunc)(),struct timeval *tv){
  (*scheFunc)();
  LPC_TIM1->MR0=(tv->tv_usec-1)*96000+offset;
}

void setTimeval(struct timeval *tv){
  tv->tv_sec=triggerTime/1000;
  tv->tv_usec=triggerTime;
}