#include "mbed.h"

void SetupTimer1(void);
void getTime(struct timeval *tv) ;
void itoa( unsigned long long int value, char *str);
void sync(void);
void Timer1_IRQHandler(void);
Serial device(p9,p10);
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
int timeNum = 0;
unsigned long long  t2=0;
unsigned long long  t3=0;
int secCom = 0;
int usecCom = 0;
int usecT1=0;
int usecT4=0;
long long tc;
int x=0;
char buffTx2[40];
char buffTx1[40];
struct timeval
{
  unsigned long long tv_sec;        /* Seconds. */
  unsigned long long tv_usec;    /* Microseconds. */
};
int main() {   
wait(0.001);  
for(int i =0;i<40;i++){
         buffTx1[i]=NULL;
         buffTx2[i]=NULL;
    }         
           SetupTimer1();   
           device.attach(&sync);   
}

void sync(void){
    
 if(device.getc()=='s'){
    t2=(unsigned long long int) (LPC_TIM1->TC+4294967296*timeNum);
    pc.printf("s receviced!\r\n");
    device.putc('d');
    t3=(unsigned long long int) (LPC_TIM1->TC+4294967296*timeNum);
    device.putc('m');
    itoa(t2,buffTx1);
    pc.printf("\r\nt2 %ul\r\n",t2);
        for(int i = 0; buffTx1[i]!=NULL;i++){
            device.putc(buffTx1[i]);
            pc.printf("%c",buffTx1[i]);
           // buffTx1[i]=NULL;
           
        } 
    device.putc('f');
    itoa(t3,buffTx2);
     pc.printf("\r\nt3 %ul timeNum %u\r\n",t3,timeNum);
        for(int i = 0; buffTx2[i]!=NULL;i++){
            device.putc(buffTx2[i]);
            pc.printf("%c",buffTx2[i]);
            
        
    }
    device.putc('n');
    myled4=!myled4;
 }        
    
}

void SetupTimer1(void)
{
   LPC_SC->PCONP |= 1 << 2;     // Power on Timer`
   LPC_SC->PCLKSEL0 |= 1 << 4;
   LPC_TIM1->TCR = 0x2;         // Reset and set to timer mode
   LPC_TIM1->CTCR = 0x0;
   LPC_TIM1->PR = 0;            // No prescale
   LPC_TIM1->MR0 = 0xFFFFFFFF;        // Match count for 100mS
   LPC_TIM1->MCR = 3;           // Interrupt and Reset on Match
   LPC_TIM1->TCR = 1;           // Enable Timer
   
   // Enable the ISR vector
   NVIC_SetVector (TIMER1_IRQn, (uint32_t)&Timer1_IRQHandler);
   NVIC_EnableIRQ(TIMER1_IRQn);
}
void Timer1_IRQHandler(void)
{
  timeNum++;
  SetupTimer1();
  LPC_TIM1->IR = 1;
}

void getTime(struct timeval *tv) {    
        tv->tv_sec=(unsigned long long)((LPC_TIM1->TC+4294967296*timeNum)/96000000);
        tv->tv_usec=(unsigned long long)((LPC_TIM1->TC+4294967296*timeNum)/96000); 
}


void itoa( unsigned long long int value, char *str)
{
   
   int i,j;
   char temp[30];
   for(i=0; value > 0; i++){
    
       str[i] = value%10+'0';
       value=value/10;
    }
    for(j=0;i>=0;j++,i--){
        temp[j]=str[i-1];
    }
    for(i=0;i<j;i++){
        str[i]=temp[i];
    }
   
   
}