#include "mbed.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
DigitalOut out(p18);
struct timeval
{
  unsigned long long tv_sec;        /* Seconds. */
  unsigned long long tv_usec;    /* Microseconds. */
};
void Timer2_IRQHandler(void);
void setupTrigger(void);
void runAtTrigger(void(*trigFunc)(struct timeval *tv));
void (*mytrigFunc)(struct timeval *tv);
void trigFunc(struct timeval *tv);
void getTime(struct timeval *tv);
timeval globalTime;
int main() {
        
        setupTrigger();
        while(1){
        wait(1);
        out=!out;
        myled=!myled;
        }   

}


void setupTrigger(void){
LPC_SC->PCONP |= 1 << 22; //power on timer 2;
LPC_PINCON->PINSEL0 |= 0x00000300;//use capture cap2.0 (pin 30)
LPC_PINCON->PINMODE0 |=0x00000100;//set pin mode of pin30(p0.04) as repeter
LPC_TIM2->TCR = 0x2;         // Reset and set to timer mode
LPC_TIM2->CTCR = 0x00000003;       //increment TC on rising and falling edge
LPC_TIM2->CCR = 0x00000007;     //trigger interrupt on rising and falling edge
LPC_TIM2->TCR = 1;           // Enable Timer

 // Enable the ISR vector
 NVIC_SetVector (TIMER2_IRQn, (uint32_t)&Timer2_IRQHandler);
 NVIC_EnableIRQ(TIMER2_IRQn);
 }
void Timer2_IRQHandler(void)
{
     myled=!myled;
     LPC_TIM2->IR = 63;
     runAtTrigger(trigFunc);
}
void runAtTrigger(void (*trigFunc) (struct timeval *tv)){
        
        (*trigFunc)(&globalTime);
}
void trigFunc(struct timeval *tv){
    getTime(tv);
    printf("time is %llu!\r\n",tv->tv_usec);
}   
void getTime(struct timeval *tv){
        tv->tv_sec =(unsigned long long int) 10;
        tv->tv_usec=(unsigned long long int) 10000;
}