/******************************************************************************/
/*                           This Nicleo is state 0                           */
/******************************************************************************/
#include "mbed.h"
 
// Initail I/O.
AnalogIn VRx(A0);
AnalogIn VRy(A1);
DigitalIn Button(PA_4);
Serial bt(PA_15, PB_7);

// Initial function.
char posit2char(int posit);
char check_joys(int jx,int jy);
int char2posit(char cha);
int IamWin();
int protect_ship(int head_position,int ship_type);
int TellUrEnemy_uWin();

int check_joys_int(int jx,int jy);
int check_correctPosition(int X,int Y);
int get_ship_platform(int input_position,int ship_type);
void atk_enemy();
void enemy_atk();
void check_ready();
void mark_ship_destroyed();
void Select_Position(char M,int SetOrPlay);
void get_atk_platform(int atkpos);
void check_end();
//inessential
void print_ship_destroyed();
void print_enemy_platform();
void print_ship_platform();
void print_atk_platform();

// Setting
int ifUrJirat = 1;
// Initial variable.
int check_ship_underATK = 0;
int select_Position = 0;
int ATKposition = 0;
int enemy_ready = 0;
int check_ship1 = 0;
int check_ship2 = 0;
int iShipType = 0;
int iWaitATK = 0;
int check_win = 0;
int state = 0;
int ship_SelectType[8] = {4,3,2,2,1,1,1,1};
int enemy_platform[8][8] = {{0}};
int ship_platform[8][8] = {{0}}; //______________________________________________This is ship area.
int atk_platform[8][8] = {{0}};
int ship_underATK[15] = {9,9,9,9,9,9,9,9,9,9,9,9,9,9,9};
int ship_destroyed[8] = {0};
int ship4[4] = {0};
int ship3[3] = {0};
int ship2[2][2] = {{0}};
int ship1[4] = {0};

int main(){ //-------------------------------------------------------------------Main Function.
    bt.baud(9600);
    float Vx;
    float Vy;
    int SW,iVxVy,iSW,n = 0;
    int uli = 0;
    char m;
    
    while(1) {
        if(iShipType<8){
            Vx = VRx.read() * 1024;
            Vy = VRy.read() * 1024;
            SW = Button.read();
            m = check_joys(Vx,Vy);
            n = check_joys_int(Vx,Vy);
            if(n == 1){ //_______________________________________________________ For make sure coordinate is press 1 time.
                iVxVy = 0;
                check_ready();
            }
            if(SW == 1){ //______________________________________________________ For make sure switch is press 1 time.
                iSW = 0;
                check_ready();
            }
            if(m!=NULL && iVxVy==0){ //__________________________________________ Get position that wait for press switch.
                Select_Position(m,1);
                printf("select_Position = %d\n",select_Position);
                check_ready();
                iVxVy = 1;
                check_ready();
            }
            if(SW==0 && iSW==0){ //______________________________________________If switch pressing by human.
                printf("Wait!\n");
                check_ready();
                if(get_ship_platform(select_Position,ship_SelectType[iShipType])==0){ //__Please read explanation in function get_ship_platform.
                    printf("Please input correct position\n");
                }else{
                    iShipType++;
                }
                check_ready();
                iSW = 1;
                print_ship_platform();
                check_ready();
            }
        }else{
            if(enemy_ready!=1){
                printf("sent E\n");
                while(uli<50){
                    bt.printf("E");
                    uli++;
                }
            }else{
                bt.putc('l');
            }
            printf("\n");
            break;
        }
    }
    if(enemy_ready == 0){
        printf("Wait for enemy\n");
        while(1){if(bt.readable()){if(bt.getc()=='l'){break;}}}
        state = 0;
    }else{state = 1;}
    wait(5);
    while(1) { //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ Play
        if(state == 0){
            atk_enemy();
            printf("This is enemy_platform.\n");
            print_enemy_platform();
            state = 1;
        }else{
            wait(1);
            enemy_atk();
            if(check_win==1){
                printf("BOO!! You Win!\n");
                break;
            }
            printf("This is atk_platform.\n");
            print_atk_platform();
            printf("This is ship_destroyed. : ");
            print_ship_destroyed();
            if(TellUrEnemy_uWin()==1){
                while(uli<100){
                    bt.putc('q');
                    uli++;
                }
                printf("BOO!! You lost!\n");
                break;
            }else{state = 0;}
        }
    }
    while(1){printf("END\n");wait(1);}
}

/******************************************************************************/
/*                                                                            */
/*                                                                            */
/*                              Another function                              */
/*                                                                            */
/*                                                                            */
/******************************************************************************/

char check_joys(int jx,int jy){ //-----------------------------------------------Check joystick that it up,down,left or right.
    
    if(ifUrJirat==1){
        if(jx < 14.0){       return 'a';}
        else if(jx > 1010.0){return 'd';}
        else if(jy < 14.0){  return 'w';}
        else if(jy > 1010.0){return 's';}
        else{return NULL;}
    }else{
        if(jx < 14.0){       return 'd';}
        else if(jx > 1010.0){return 'a';}
        else if(jy < 14.0){  return 's';}
        else if(jy > 1010.0){return 'w';}
        else{return NULL;}
    }
}
int check_joys_int(int jx,int jy){ //--------------------------------------------Check joystick that it is centre.
    if(jx>=450.0&&jx<=600.0){
        if(jy>=450.0&&jy<=600.0){
            return 1;
        }else{
            return 0;
        }
    }else{
        return 0;
    }
}
void Select_Position(char M,int SetOrPlay){ //-------------------------------------------------Change position of cursor (Joystick).
    int protect_ships;
    protect_ships = protect_ship(select_Position,ship_SelectType[iShipType]);
    switch(M){
        case 'a':
            if(select_Position%10!=0){
                select_Position = select_Position - 1;
            }
            break;
        case 'd':
            if(select_Position%10!=7){
                if(protect_ships==1 or protect_ships==0){
                    select_Position = select_Position + 1;
                }
                if(SetOrPlay==0){
                    select_Position = select_Position + 1;
                }
            }
            break;
        case 'w':
            if(select_Position/10!=0){
                select_Position = select_Position - 10;
            }
            break;
        case 's':
            if(select_Position/10!=7){
                if(protect_ships==1 or protect_ships==2){
                    select_Position = select_Position + 10;
                }
                if(SetOrPlay==0){
                    select_Position = select_Position + 10;
                }
            }
            break;
    }
}
int protect_ship(int head_position,int ship_type){
    int x,y = 0;
    y = head_position/10;
    x = head_position%10;
    if(ship_type==4){if((y+4)>7){return 0;}else{return 1;}}
    else if(ship_type==3){if((x+3)>7){return 2;}else{return 1;}}
    else if(ship_type==2){if((y+2)>7){return 0;}else{return 1;}}
    else{return 1;}
}
int get_ship_platform(int input_position,int ship_type){ //-----------------------Plot ship in ship area.
    int i,x,y = 0;
    int error = 0;

    y = input_position/10;
    x = input_position%10;

    for(i=0;i<ship_type;i++){
        if(check_correctPosition(y,x) == 1){
            if(ship_type == 4){ship4[i] = (y*10)+x;}
            else if(ship_type == 3){ship3[i] = (y*10)+x;}
            else if(ship_type == 2){ship2[check_ship2][i] = (y*10)+x;}
            else if(ship_type == 1){ship1[check_ship1] = (y*10)+x;check_ship1++;}
        }else{error = 1;break;}
        if(ship_type%2 == 0){y++;}else{x++;}
    }
    if(ship_type==2){check_ship2++;}
    if(error == 1){return 0;}else{
        y = input_position/10;
        x = input_position%10;
        for(i=0;i<ship_type;i++){
            ship_platform[y][x] = ship_type;
            if(ship_type%2 == 0){y++;}else{x++;}
        }
        return 1;
    }
}
int check_correctPosition(int X,int Y){
    if(X<=7){
        if(Y<=7){
            if(ship_platform[X][Y] == 0){return 1;}else{return 0;}
        }else{return 0;}
    }else{return 0;}
}
void print_ship_platform(){
    for(int i=0;i<8;i++){
        for(int j=0;j<8;j++){
            printf("| %d |",ship_platform[i][j]);
        }
        printf("\n");
    }
}
void print_enemy_platform(){
    for(int i=0;i<8;i++){
        for(int j=0;j<8;j++){
            printf("| %d |",enemy_platform[i][j]);
        }
        printf("\n");
    }
}
void print_atk_platform(){
    for(int i=0;i<8;i++){
        for(int j=0;j<8;j++){
            printf("| %d |",atk_platform[i][j]);
        }
        printf("\n");
    }
}
void print_ship_destroyed(){
    printf("{");
    for(int i=0;i<8;i++){
        printf("%d",ship_destroyed[i]);
        if(i!=14){printf(",");}
    }
    printf("}\n");
}
void check_ready(){
    if(bt.readable()){enemy_ready = 1;}
}
char posit2char(int posit){
    int as = posit+48;
    char ch = as;
    return ch ;
}
int char2posit(char cha){
    int as = cha;
    as = as-48;
    return as;
}
void get_atk_platform(int atkpos){
    int i,j,x,y = 0;

    x = atkpos/10;
    y = atkpos%10;
    
    if(ship_platform[x][y]!=0 and atk_platform[x][y]==0){
        atk_platform[x][y] = ship_platform[x][y];
        bt.putc(posit2char(atk_platform[x][y]));
        ship_underATK[check_ship_underATK] = (x*10)+y;
        if(atk_platform[x][y]==4){
            for(i=0;i<4;i++){
                for(j=0;j<15;j++){
                    if(ship4[i]==ship_underATK[j]){ship_destroyed[0]++;}
                }
            }
        }else if(atk_platform[x][y]==3){
            for(i=0;i<3;i++){
                for(j=0;j<15;j++){
                    if(ship3[i]==ship_underATK[j]){ship_destroyed[1]++;}
                }
            }
        }else if(atk_platform[x][y]==2){
            for(i=0;i<4;i++){
                for(j=0;j<15;j++){
                    if(ship2[0][i]==ship_underATK[j]){ship_destroyed[2]++;}
                    if(ship2[1][i]==ship_underATK[j]){ship_destroyed[3]++;}
                }
            }
        }else if(atk_platform[x][y]==1){
            for(i=0;i<4;i++){
                for(j=0;j<15;j++){
                    if(ship3[i]==ship_underATK[j]){
                        ship_destroyed[4+i]++;
                        atk_platform[x][y] = 11;
                    }
                }
            }
        }
    }else{
        if(atk_platform[x][y]!=0){
            printf("You repeatedly attacked.\n");
        }else{
            atk_platform[x][y] = 8;
            bt.putc(posit2char(atk_platform[x][y]));
        }
    }
}
void mark_ship_destroyed(){
    int i,j,k = 0;
    
    if(ship_destroyed[0]==10){
        for(i=0;i<8;i++){
            for(j=0;j<8;j++){
                if(atk_platform[i][j]==4){atk_platform[i][j] = 11;}
            }
        }
    }
    if(ship_destroyed[1]==6){
        for(i=0;i<8;i++){
            for(j=0;j<8;j++){
                if(atk_platform[i][j]==3){atk_platform[i][j] = 11;}
            }
        }
    }
    if(ship_destroyed[2]==3){
        for(k=0;k<2;k++){
            i = ship2[0][k]/10;
            j = ship2[0][k]%10;
            atk_platform[i][j] = 11;
        }
    }
    if(ship_destroyed[3]==3){
        for(k=0;k<2;k++){
            i = ship2[1][k]/10;
            j = ship2[1][k]%10;
            atk_platform[i][j] = 11;
        }
    }
}
void atk_enemy(){
    float Vx;
    float Vy;
    int SW,iVxVy,iSW,n = 0;
    int iPrintUturn = 0;
    char m;
    
    select_Position = 0;
    while(1){
        if(iPrintUturn==0){
            printf("Your turn.\n");
            iPrintUturn = 1;
        }
        Vx = VRx.read() * 1024;
        Vy = VRy.read() * 1024;
        SW = Button.read();
        m = check_joys(Vx,Vy);
        n = check_joys_int(Vx,Vy);
        if(n == 1){ iVxVy = 0;}
        if(SW == 1){
            iSW = 0;
            if(bt.readable()){
                enemy_platform[select_Position/10][select_Position%10] = char2posit(bt.getc());
                break;
            }
        }
        if(m!=NULL && iVxVy==0){
            Select_Position(m,1);
            printf("select_Position = %d\n",select_Position);
            bt.putc(posit2char(select_Position));
            iVxVy = 1;
        }
        if(SW==0 && iSW==0){
            bt.putc('B');
            printf("You attacking at position %d\n",select_Position);
            iSW = 1;
        }
    }
}
void enemy_atk(){
    int data_fromEnemy;
    char replica_data_fromEnemy;
    printf("Wait for enemy attack.\n");
    select_Position = 0;
    while(1){
        if(bt.readable()){
            replica_data_fromEnemy = bt.getc();
            if(replica_data_fromEnemy!='q' and replica_data_fromEnemy!=8){
                data_fromEnemy = char2posit(replica_data_fromEnemy);
                if(data_fromEnemy!=18){
                    select_Position = data_fromEnemy;
                    printf("enemy select_Position = %d\n",select_Position);
                }else{
                    ATKposition = select_Position;
                    break;
                }
            }
            if(replica_data_fromEnemy=='q'){
                check_win = 1;
                break;
            }
        }
    }
    if(check_win!=1){
        printf("Enemy attack at your area %d\n",ATKposition);
        get_atk_platform(ATKposition);
        check_ship_underATK++;
        mark_ship_destroyed();
    }
}
int TellUrEnemy_uWin(){
    int sub_end = 0;
    
    for(int i=0;i<15;i++){
        if(ship_underATK[i]!=9){sub_end++;}
    }
    if(sub_end==15){return 1;}else{return 0;}
}
int IamWin(){
    char chare;
    if(bt.readable()){
        chare = bt.getc();
        if(chare=='q'){return 1;}else{return 0;}
    }else{return 0;}
}