#include "ssRadio.h"
#include "WakeUp.h"

SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK);
SSRadio *radio;
//Serial pc(SERIAL_TX, SERIAL_RX);

void onData(uint8_t *data, uint16_t type, uint8_t size) {
  //pc.printf("Data received.\n");
  //pc.printf("Type: %d\n", type);
  //pc.printf("Size: %d", size);
}

void loop();

int main() {
  //pc.baud(115200);
  //Serial.println(F("Hello World!"));

  spi.frequency(8000000);
  spi.format(8, 0);

  NodeConfig nc(PA_1, PA_2);
  //nc.setSyncAddress(0x3333333333L);
  //nc.setNodeAddress(0x424D451110L); // This is stored in EEPROM or uinqID
  nc.setSyncAddress(0x424D452AD2L);
  nc.setGwId(0x2AE1);
  nc.setChannel(112);

  //Serial.println("I'm " + String(nc.getNodeId()));
  //Serial.flush();

  radio = new SSRadio(&spi, &nc);
  radio->init();

  radio->setOnReceiveData(&onData);
  
  if (!radio->isRunning()) {
    //pc.printf("Error Radio is not working!");
  } else {
    //pc.printf("Working.");
  }
  
  WakeUp::calibrate();
  
  while (1) { loop(); }
}

long last = 0;

void loop() {
  // put your main code here, to run repeatedly:
  
  WakeUp::set_ms(2000);
  //deepsleep();
  // Stop HAL tick to avoid to exit sleep in 1ms
  HAL_SuspendTick();
  // Request to enter SLEEP mode
  HAL_PWR_EnterSLEEPMode(PWR_MAINREGULATOR_ON, PWR_SLEEPENTRY_WFI);
  // Restart HAL tick
  HAL_ResumeTick();
            
  radio->sendData((uint8_t*)"Hello", 6, 6);
  radio->loop();
  
  //long now = us_ticker_read() / 1000;
  //if (now - last > 1000) {}
    //pc.printf("Hello");
  
}
 