#ifndef T15MSG_H
#define T15MSG_H

#include "mbed.h"

class T15Msg {

    char counter1;
    char counter2;

    bool enginerun;
    bool ignition;
    bool clutch;

    char enginestate;
    int statecounter;
    bool sstart;
    bool sstop;

    char data[5];

    void updateData(char resetc1 = 0x10);
    void updateState();

    public:
        T15Msg();

        bool sendMessage(CAN *can);
        bool start();
        bool stop();
};

#endif

// About T15

/*

uint8_t t15_counter; // a counter, where hi and low part counts separately, and one number is missing
                     // E.g: 64, 75, 86, 97, A8, B9, CA, DB, FC, 0D, 1E, 20, 31, 42, 53, 64 ...
                     // high bit counter tends to jump on key/ignition 'events'
    // T15

    0: 00h engine off, 40h engine off (key is being inserted), 41h engine off (key in position 1 also this value when engine is stopped)
      45h engine running. (also key to position 2), 55h engine is turning on (from key or auto stop start)
    1: 00h key not in slot, 40h key in slot
    2[8765]: key||engine: clutch: 0x6/0x2, no key,no engine: 0xD
    2[4321]: 1: engine running, 2: ignition
    3[8]: engine running
    3[4321]: 1111
    4: timer (1.4 sec)
    
    Sent in every 100ms
*/