#include "T15Msg.h"

T15Msg::T15Msg () {

    counter1 = 0;
    counter2 = 0;

    enginerun = false;
    ignition = false;
    clutch = false;

    enginestate = 0;
    statecounter = 0;

    sstart = false;
    sstop = false;

    updateData();
}

void T15Msg::updateState() {

    switch (enginestate) {
        case 1:
            statecounter++;
            if (sstart && statecounter > 1) {
                enginestate = 2;
                statecounter = 0;
                ignition = true;
                updateData(4);
            }
            if (sstop && statecounter > 24) {
                enginestate = 0;
                statecounter = 0;
                updateData(0xc);
                sstop = false;
            }
            break;

        case 2:
            enginestate = 6;
            statecounter = 0;
            updateData(9);
            break;

        case 6:
            statecounter++;
            if (ignition) {
                if (statecounter > 8) {
                    enginestate = 9;
                    statecounter = 0;
                    updateData(0xd);
                }
            } else {
                if (statecounter == 3) {
                    enginerun = false;
                    updateData();
                } else if (statecounter > 3) {
                    enginestate = 5;
                    statecounter = 0;
                    updateData(7);
                }
            }
            break;

        case 9:
            statecounter++;
            if (statecounter == 3) {
                ignition = false;
                enginerun = true;
                updateData();
            }
            if (statecounter > 28) {
                enginestate = 8;
                updateData(8);
                sstart = false;
            }
            break;

        case 4:
            enginestate = 6;
            statecounter = 0;
            updateData(0);
            break;

        case 5:
            statecounter++;
            if (statecounter > 1) {
                enginestate = 1;
                statecounter = 0;
                updateData();
            }
            break;
    }
}

void T15Msg::updateData(char resetc1) {

    if (enginerun) {
        data[0] = 0x45;
    } else {
        if (ignition) data[0] = 0x55;
        else data[0] = 0x41;
    }

    data[1] = 0x42;

    if (clutch) data[2] = 0x61;
    else data[2] = 0x21;
    if (enginestate == 2 || enginestate == 6) data[2] |= 0x8;

    data[3] = enginestate << 4 | 0xf;

    if (resetc1 < 0x10) counter1 = resetc1;
}

bool T15Msg::sendMessage(CAN *can) {

    data[4] = counter1 << 4 | counter2;
    bool ok = can->write(CANMessage(0x130, data, 5));
    //bool ok = can->write(0x130, (char*) data, 5);

    counter1 = (counter1 + 1) & 0x0f;
    if (counter1 == 6) counter1++;
    counter2 = (counter2 + 1) & 0x0f;
    if (counter2 == 0xf) counter2 = 0;

    if (enginestate != 0 &&  enginestate != 8) {
        updateState();
    }

    return ok;
}

bool T15Msg::start() {

    if (enginestate == 8) return false;
    if (sstart || sstop) return false;

    enginestate = 1;
    statecounter = 0;
    sstart = true;
    updateData(4);

    return true;
}

bool T15Msg::stop() {

    if (enginestate == 0) return false;
    if (sstart || sstop) return false;

    enginestate = 4;
    statecounter = 0;
    sstop = true;
    updateData(5);

    return true;
}
