// tasks -------------------------------
  
// Task 1 - GPS Serial Task
#define GPS_SERIAL_TASK              1
#define GPS_SER_PRIORITY            50
#define GPS_SER_STACK_SZ          2048
void GpsSerialTask(void);  

// Task 2 - Keypad read
#define KEYPAD_TASK                  2
#define KEYPAD_PRIORITY             50
#define KEYPAD_STACK_SZ            256
void KeypadTask(void);  

// Task 3 - Show LCD
#define SHOW_LCD_TASK                3
#define SHOW_LCD_PRIORITY           50
#define SHOW_LCD_STACK_SZ          256
void ShowLcdTask(void);  

// Task 4 - Led Blink
#define LED_BLINK_TASK               4
#define LED_BLINK_PRIORITY          50
#define LED_BLINK_STACK_SZ         256
void LedBlinkTask(void); 

// Task 5 - Set Time
#define SET_TIME_TASK                5
#define SET_TIME_PRIORITY           50
#define SET_TIME_STACK_SZ          256
void SetTimeTask(void); 

// Task 6 - Show PC
#define SHOW_PC_TASK                 6
#define SHOW_PC_PRIORITY            50
#define SHOW_PC_STACK_SZ           512
void ShowPcTask(void);  

// Task 7 - LCD backlight dim
#define LCD_LIGHT_DIM_TASK           7
#define LCD_LIGHT_DIM_PRIORITY      50
#define LCD_LIGHT_DIM_STACK_SZ     256
void LcdLightDimTask(void);  

// Task 8 - Temp task used for tests
#define TEMP_TASK                    8
#define TEMP_PRIORITY               50
#define TEMP_STACK_SZ               32
void TempTask(void);  

// Task 9 - Kick the WDT dog
#define WDT_TASK                     9
#define WDT_PRIORITY                90
#define WDT_STACK_SZ               128
void WdtTask(void);  


#define NUM_TASKS                    9

// timers ------------------------------
#define KEYPAD_TMR                   0
#define SHOW_LCD_TMR                 1
#define LED_BLINK_TMR                2
#define SET_TIME_TMR                 3
#define SHOW_PC_TMR                  4
#define LCD_LIGHT_DIM_OFF_TMR        5
#define TEMP_TMR                     6
#define WDT_TMR                      7

#define NUM_TIMERS                   8

// resources ---------------------------
#define PC_SERIAL                    0
#define PC_SERIAL_PRIO              70

#define GPS_SERIAL                   1
#define GPS_SERIAL_PRIO             70

#define LCD                          2
#define LCD_PRIO                    70

#define LCD_LIGHT_DIM                3
#define LCD_LIGHT_DIM_PRIO          70

#define NUM_RESOURCES                4

// Events ------------------------------
#define GPS_SERIAL_IN_EVT     0x00000001
#define KEYPAD_EVT            0x00000002
#define SHOW_LCD_EVT          0x00000004
#define LED_BLINK_EVT         0x00000008
#define SET_TIME_EVT          0x00000010
#define SHOW_PC_EVT           0x00000020
#define LCD_LIGHT_DIM_ON_EVT  0x00000040
#define LCD_LIGHT_DIM_OFF_EVT 0x00000080
#define TEMP_EVT              0x00000100
#define WDT_EVT               0x00000200

