#include "Task3Lcd.h"

void ShowLcdTask(void)
{/**
 *\brief TASK 3, display desired data on LCD
 */
 
 static int Previous=0;

 os.SetTimer(SHOW_LCD_TMR, SHOW_LCD_TIMER, 0);
 while(1)
 {
 os.WaitEvent(SHOW_LCD_EVT);

    if(Previous != Menu)
    {// clear the display when function changes
        lcd.cls();
        Previous=Menu;
    }
    
    switch(Menu)
    {
        case 0:
            showSatLcd();
            Previous=0;
            break;
            
        case 1:
            if(info.sig != 0)
            {
                showInfoLcd();
            }
            else
            {
                showSatLcd();
            }
            Previous=1;    
            break;
        
        case 2:
            showMenuLcd();
            Previous=2;    
            break;
            
        case 3:
            showMenuLcd1();
            Previous=3;    
            break;  
            
        case 4: 
            ShowPathLcd();
            Previous=4;    
            break; 
            
        default:
            showInfoLcd();
            break;
    }
    //restart timer for other options
    os.SetTimer(SHOW_LCD_TMR, SHOW_LCD_TIMER, 0); 
 }
}

void ShowPathLcd(void)
{
    static int ChooseDir=0;
    DegMinSec DecCoord;

    Ang[Gps]=info.direction;
    Ang[Mag]=CmpRead()-info.declination; //Compass reading corrected by declination
    Ang[Dir]=Path.Azimuth[0];

    ChooseDir++;
    if(ChooseDir<7)
    {
        showDirLcd(Mag);
    }
    else if(ChooseDir>=7 && ChooseDir<12)
    {
        showDirLcd(Gps);
    }
    else if(ChooseDir>=12)
    {
       ChooseDir=0;
    }
    showDirLcd(Dir);
    
    Deg2DegMinSec(nmea_ndeg2degree(Dest.lat), &DecCoord);
    lcd.locate(6,0);
    lcd.printf("%d%d\'%.0f", DecCoord.Deg, DecCoord.Min, DecCoord.Sec);
    lcd.printf("%c", Dest.lat >= 0 ? 'N': 'S');  
    
    Deg2DegMinSec(nmea_ndeg2degree(Dest.lon), &DecCoord);
    lcd.locate(6,1);
    lcd.printf("%d%d\'%.0f", DecCoord.Deg, DecCoord.Min, DecCoord.Sec);
    lcd.printf("%c", Dest.lon >= 0 ? 'E': 'W');  
    
    lcd.locate(6,2);
    lcd.printf(" dist m");
    lcd.locate(6,3);
    lcd.printf("%4.3f",Path.Dist);
    

}

void showDirLcd(int Indx)
{/**
 *\brief  display a sort of compass on LCD
 */
    int Angle;

    Angle=Ang[Indx]/18;

    lcd.locate(CmpPos[Indx],0);
    lcd.printf("  %c  ",0xA5);
    lcd.locate(CmpPos[Indx],1);
    lcd.printf("%c   %c",0xA5, 0xA5);
    lcd.locate(CmpPos[Indx],2);
    lcd.printf("%c   %c",0xA5, 0xA5);
    lcd.locate(CmpPos[Indx],3);
    lcd.printf("  %c  ",0xA5);
    
    lcd.locate(CmpPos[Indx]+1,1);
    lcd.printf(Lab[Indx]);
    lcd.locate(CmpPos[Indx]+1,2);
    lcd.printf("%03i",Ang[Indx]);
        
    switch (Angle)
    {
        case 0:
            lcd.locate(CmpPos[Indx]+2,0);
            lcd.printf("%c",0xFF);
            break;
        case 1:
            lcd.locate(CmpPos[Indx]+2,0);
            lcd.printf("%c",0xFF);
            lcd.locate(CmpPos[Indx]+3,0);
            lcd.printf("%c",0xFF);
            break;
        case 2:
            lcd.locate(CmpPos[Indx]+3,0);
            lcd.printf("%c",0xFF);
            break;        
        case 3:
            lcd.locate(CmpPos[Indx]+3,0);
            lcd.printf("%c",0xFF);
            lcd.locate(CmpPos[Indx]+4,1);
            lcd.printf("%c",0xFF);
            break;        
        case 4:
            lcd.locate(CmpPos[Indx]+4,1);
            lcd.printf("%c",0xFF);
            break;
        case 5:       
            lcd.locate(CmpPos[Indx]+4,1);
            lcd.printf("%c",0xFF);
            lcd.locate(CmpPos[Indx]+4,2);
            lcd.printf("%c",0xFF);
            break;
        case 6:   
            lcd.locate(CmpPos[Indx]+4,2);
            lcd.printf("%c",0xFF);
            break;
        case 7:       
            lcd.locate(CmpPos[Indx]+4,2);
            lcd.printf("%c",0xFF);
            lcd.locate(CmpPos[Indx]+3,3);
            lcd.printf("%c",0xFF);
            break;
        case 8:   
            lcd.locate(CmpPos[Indx]+3,3);
            lcd.printf("%c",0xFF);
            break;
        case 9:       
            lcd.locate(CmpPos[Indx]+3,3);
            lcd.printf("%c",0xFF);
            lcd.locate(CmpPos[Indx]+2,3);
            lcd.printf("%c",0xFF);
            break;
        case 10:   
            lcd.locate(CmpPos[Indx]+2,3);
            lcd.printf("%c",0xFF);
            break;     
        case 11:       
            lcd.locate(CmpPos[Indx]+2,3);
            lcd.printf("%c",0xFF);
            lcd.locate(CmpPos[Indx]+1,3);
            lcd.printf("%c",0xFF);
            break;
        case 12:   
            lcd.locate(CmpPos[Indx]+1,3);
            lcd.printf("%c",0xFF);
            break;     
        case 13:       
            lcd.locate(CmpPos[Indx]+1,3);
            lcd.printf("%c",0xFF);
            lcd.locate(CmpPos[Indx]+0,2);
            lcd.printf("%c",0xFF);
            break;
        case 14:   
            lcd.locate(CmpPos[Indx]+0,2);
            lcd.printf("%c",0xFF);
            break;  
        case 15:       
            lcd.locate(CmpPos[Indx]+0,2);
            lcd.printf("%c",0xFF);
            lcd.locate(CmpPos[Indx]+0,1);
            lcd.printf("%c",0xFF);
            break;
        case 16:   
            lcd.locate(CmpPos[Indx]+0,1);
            lcd.printf("%c",0xFF);
            break;  
        case 17:       
            lcd.locate(CmpPos[Indx]+0,1);
            lcd.printf("%c",0xFF);
            lcd.locate(CmpPos[Indx]+1,0);
            lcd.printf("%c",0xFF);
            break;   
        case 18:   
            lcd.locate(CmpPos[Indx]+1,0);
            lcd.printf("%c",0xFF);
            break;  
        case 19:       
            lcd.locate(CmpPos[Indx]+1,0);
            lcd.printf("%c",0xFF);
            lcd.locate(CmpPos[Indx]+2,0);
            lcd.printf("%c",0xFF);
            break;   
    }
}

void showMenuLcd(void)
{/**
 *\brief  display a selection menu on LCD
 */
    lcd.locate(0,0);
    lcd.printf("1 - item 1");
    lcd.locate(0,1);
    lcd.printf("2 - item 2");
    lcd.locate(0,2);
    lcd.printf("3 - item 3");
    lcd.locate(0,3);
    lcd.printf("4 - item 4");    
}

void showMenuLcd1(void)
{/**
 *\brief  display a selection menu on LCD
 */
    lcd.locate(0,0);
    lcd.printf("5 - item 5");
    lcd.locate(0,1);
    lcd.printf("6 - item 6");
    lcd.locate(0,2);
    lcd.printf("7 - item 7");
    lcd.locate(0,3);
    lcd.printf("8 - item 8");    
}

void showSatLcd(void) 
{/**
 *\brief displays satellite informations
 */
    for (int i = 0; i < NMEA_MAXSAT; i++) 
    {
        if(info.satinfo.sat[i].id < 20)
        {
            lcd.locate((info.satinfo.sat[i].id % 20) - 1,0);
        }
        else
        {
            lcd.locate((info.satinfo.sat[i].id % 20) - 1,1);    
        }
        
        if (info.satinfo.sat[i].sig > 0)
        {
            lcd.printf("%d",info.satinfo.sat[i].sig/10);
        }
        else
        {
            lcd.printf(" ");    
        }                   
    }
    lcd.locate(0,2);
    lcd.printf("12345678901234567890");
    lcd.locate(0, 3);
    lcd.printf("P%2.1f H%2.1f V%2.1f %iD",
    info.PDOP, info.HDOP, info.VDOP,info.fix);
}    
    
void showInfoLcd(void) 
{/**
 *\brief Show nmea info on LCD 
 */

//    static int lastSat = 0;
//    int satInview = 0;

 if(info.sig != 0)
 { 
    lcd.locate(0, 0);
    lcd.printf("%2.5f%c %3.5f%c",
            latitude, info.lat >= 0 ? 'N': 'S',  
            longitude, info.lon >= 0 ? 'E': 'W');
  
    lcd.locate(0, 1);
    lcd.printf("H%.0f D%.0f_%.1f %iD", info.elv, info.direction, info.declination, info.fix);

    lcd.locate(0, 2);
    lcd.printf("P%2.1f H%2.1f V%2.1f S%i/%i",
        info.PDOP, info.HDOP, info.VDOP, info.satinfo.inuse, info.satinfo.inview);
        
   /* lcd.locate(0, 3);
    lcd.printf("%02d-%02d-%04d %02d:%02d:%02d ", 
        info.utc.day, info.utc.mon + 1, info.utc.year + 1900,
        info.utc.hour, info.utc.min, info.utc.sec); // Display JST (UTC + 9)
   */

/*
    lcd.locate(0, 5);
    for (int i = 0; i < NMEA_MAXSAT; i++) {
        if (info.satinfo.sat[i].sig > 0) {
            satInview++;
            lcd.printf("  sat_id:%02d, sig:%02d, Inuse:%d \n",
                      info.satinfo.sat[i].id , info.satinfo.sat[i].sig,
                      info.satinfo.sat[i].in_use);
        }
    }
    for (int j = satInview; j <= lastSat; j++)
        lcd.printf("                             \n");     // delete line
    lastSat = satInview;
 */
 
 } 
 else
 {
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("NO FIX"); 
 }

 // Grab a snapshot of the current RTC time.
 time_t seconds = time(NULL);
 char buffer[32];
 if((info.sig != 0)&&(SetTimeOk!=0))  
 {
    strftime(buffer, 32, "%x %X", localtime(&seconds));
 }
 else
 {// if GPS time not valid doesn't display seconds
     strftime(buffer, 32, "%x %H:%M", localtime(&seconds));
     SetTimeOk = 0; // RTC was not set to a valid time 
 }
 lcd.locate(0,3);
 lcd.printf("%s", buffer);
}