#include "Task6Pc.h"

void ShowPcTask(void) 
{/**
 *\brief TASK 6, if a PC is connected, debug information can be sent to the console
 */
 static int it = 0;
 int i;
 DegMinSec DecCoord;
    
 os.SetTimer(SHOW_PC_TMR, 1000, 1000);
 while(1)
 {
    os.WaitEvent(SHOW_PC_EVT); 

    if(pc.readable())
    {// wait for an input
        PcMonitor = (pc.getc()-48); // digit a number to en/dis-able debug
     }
     
    if( PcMonitor==1 || PcMonitor>5)
    {// Display Info parameters 
        pc.printf(
        "%03d, Lat: %f, Lon: %f, Sig:%d, Fix:%d, Inuse:%d\r\n",
        it++, latitude, longitude, info.sig, info.fix, info.satinfo.inuse );
        for (i = 0; i < NMEA_MAXSAT; i++) 
            {
            if (info.satinfo.sat[i].sig > 0)
            pc.printf("  sat_id:%02d, sig:%02d, Inuse:%d\r\n",
                      info.satinfo.sat[i].id , info.satinfo.sat[i].sig, 
                      info.satinfo.sat[i].in_use);
            }
        pc.printf("\r\n");
    }
    
    if( PcMonitor==2 || PcMonitor>5)
    {// Display Distance parameters 
        Deg2DegMinSec(nmea_radian2degree(Pos[0].lat), &DecCoord);
        pc.printf("Lat1:%d %d\'%.3f\"  ", DecCoord.Deg, DecCoord.Min, DecCoord.Sec);
        Deg2DegMinSec(nmea_radian2degree(Pos[0].lon), &DecCoord);
        pc.printf("Lon1:%d %d\'%.3f\"  ", DecCoord.Deg, DecCoord.Min, DecCoord.Sec);
        Deg2DegMinSec(nmea_radian2degree(Pos[1].lat), &DecCoord);
        pc.printf("Lat2:%d %d\'%.3f\"  ", DecCoord.Deg, DecCoord.Min, DecCoord.Sec);
        Deg2DegMinSec(nmea_radian2degree(Pos[1].lon), &DecCoord);
        pc.printf("Lon2:%d %d\'%.3f\"  \n", DecCoord.Deg, DecCoord.Min, DecCoord.Sec);
        pc.printf("Dist:%f  Azimuth Start:%f  Azimuth Final:%f \n\n",
                  Path.Dist, Path.Azimuth[0], Path.Azimuth[1]); 
    }
  }   
}