#include "Task2Keypad.h"

void KeypadTask(void)
{/**
 *\brief TASK 2, Keypad management. 
         It uses just one ADC port. Five keys switch a 5 resistor ladder
         obtaining a unique voltage for each key, with a priority that 
         depends from the position of the resistor in the ladder.
         This function makes an average of 50 analog values (50ms) before 
         confirming the output, to filter out some noise and debounce keys
 */

    static float KeypadAcc;         // accumulator to compute average
    static float KeypadPrev;        // previous value to compute variation 
    static int KeypadCount;         // all samples number
    static int KeypadRealCount;     // valid samples only
    float KeypadVal;  
    static char KeyPrev='-';
    
    os.SetTimer(KEYPAD_TMR, 1, 1);
    while(1)
    {
        os.WaitEvent(KEYPAD_EVT);
        float InValue = KeypadIn.read();
        if ((InValue > 0.3) && (abs(InValue - KeypadPrev) < 0.1))
        {// makes the average only of the values above a threshold 
         // and within an almost stable range
            KeypadAcc+=InValue;
            KeypadRealCount++;
        }
            
        KeypadCount++;
        KeypadPrev=InValue;
    
        if (KeypadCount >=50)
        {
            if(KeypadRealCount > 25)
            {
                KeypadVal=KeypadAcc/KeypadRealCount;
            }
            else
            {// not enough values to average
    
                KeypadVal=0;
            }
           
            KeypadAcc=0;
            KeypadCount=0;
            KeypadRealCount=0;
         
            if(KeypadVal <0.15)
            {
                Key='-';
            }
            else if(KeypadVal>=0.3 && KeypadVal<0.35)
            {
                Key='E';
            }
            else if(KeypadVal>=0.42 && KeypadVal<0.50)
            {
                Key='v';
            }
            else if(KeypadVal>=0.60 && KeypadVal<0.65)
            {
                Key='^';
            }
            else if(KeypadVal>=0.74 && KeypadVal<0.78)
            {
                Key='>';
            }        
            else if(KeypadVal>=0.85)
            {
                Key='<';
            }
            
            if (Key!='-' && Key!=KeyPrev)
            {// switch on the LCD backlight if key pressed
                os.SetEvent(LCD_LIGHT_DIM_ON_EVT, LCD_LIGHT_DIM_TASK);
            }
            KeyPrev=Key;
            switch (Key)
            {
                case '^':
                    Menu=0;
                break;
     
                case '>':
                    Menu=1;
                break;           
     
                case 'v':
                    Menu=2;
                break;
                
                case '<':
                    Menu=3;
                break;
                
                case 'E':
                    Menu=4;
                break;
            }     
       }
   } 
}
