#include "Startup.h"

void Initialize (void)
{
// initialize serial ports
pc.baud(PCBAUD); // USB/serial
gps.baud(GPSBAUD);

gps.attach( &GpsSerialIsr );  // Start serial interrupt

nmea_property()->trace_func = &trace_h;
nmea_property()->error_func = &error_h;
nmea_zero_INFO(&info);
nmea_parser_init(&parser);
     
LcdBklight = 0;
wait(0.5);
lcd.cls();
LcdBklight=1; // Backlight on

// LCD splash screen
lcd.locate(0,1);
lcd.printf(Ver1);
lcd.locate(0,2);
lcd.printf(Ver2);
wait(4.0);
lcd.cls();
   
// Console splash screen
pc.printf(Ver1); 
pc.printf("\n");   
pc.printf(Ver2); 
pc.printf("\n"); 
pc.printf("input a number to enable debug, 0 to disable\n");

os.CreateTask(GPS_SERIAL_TASK, GPS_SER_PRIORITY, GPS_SER_STACK_SZ, GpsSerialTask);
os.CreateTask(KEYPAD_TASK, KEYPAD_PRIORITY, KEYPAD_STACK_SZ, KeypadTask);
os.CreateTask(SHOW_LCD_TASK, SHOW_LCD_PRIORITY, SHOW_LCD_STACK_SZ, ShowLcdTask);
os.CreateTask(LED_BLINK_TASK, LED_BLINK_PRIORITY, LED_BLINK_STACK_SZ, LedBlinkTask);
os.CreateTask(SET_TIME_TASK, SET_TIME_PRIORITY, SET_TIME_STACK_SZ, SetTimeTask);
os.CreateTask(SHOW_PC_TASK, SHOW_PC_PRIORITY, SHOW_PC_STACK_SZ, ShowPcTask);
os.CreateTask(LCD_LIGHT_DIM_TASK, LCD_LIGHT_DIM_PRIORITY, LCD_LIGHT_DIM_STACK_SZ, LcdLightDimTask);
os.CreateTask(TEMP_TASK, TEMP_PRIORITY, TEMP_STACK_SZ, TempTask);
os.CreateTask(WDT_TASK, WDT_PRIORITY, WDT_STACK_SZ, WdtTask);

os.CreateResource(GPS_SERIAL,GPS_SERIAL_PRIO);  
os.CreateResource(PC_SERIAL,PC_SERIAL_PRIO);  
os.CreateResource(LCD,LCD_PRIO);  
os.CreateResource(LCD_LIGHT_DIM,LCD_LIGHT_DIM_PRIO);

os.CreateTimer(KEYPAD_TMR, KEYPAD_TASK, KEYPAD_EVT);
os.CreateTimer(SHOW_LCD_TMR, SHOW_LCD_TASK, SHOW_LCD_EVT);
os.CreateTimer(LED_BLINK_TMR, LED_BLINK_TASK, LED_BLINK_EVT);
os.CreateTimer(SET_TIME_TMR, SET_TIME_TASK, SET_TIME_EVT);  
os.CreateTimer(SHOW_PC_TMR, SHOW_PC_TASK, SHOW_PC_EVT);
os.CreateTimer(LCD_LIGHT_DIM_OFF_TMR, LCD_LIGHT_DIM_TASK, LCD_LIGHT_DIM_OFF_EVT);
os.CreateTimer(TEMP_TMR, TEMP_TASK, TEMP_EVT);
os.CreateTimer(WDT_TMR, WDT_TASK, WDT_EVT);

os.SetTimer(LCD_LIGHT_DIM_OFF_TMR, LCD_LIGHT_DIM_TIMER, 0);

// os.SetTimer(TEMP_TMR, TEMP_TIMER, TEMP_TIMER); // enabled just for test or debug

ReadCfg(Config);
WriteCfg();
ReadCfg(Config);
}
