/* ////////////////////////////////////////////////////////////////////////////
** File:      LeonardoMbos.cpp
*/    
/*               12345678901234567890                                        */                               
 char  Ver1[] = "Leonardo's GPS 0.1.0";
 char  Ver2[] = "  by Guiott  01-12";
/**
* @mainpage Leonardo.cpp
* @author   Guido Ottaviani-->guido@guiott.com<--
* @version  0.1.0
* @date     01/2012
* @details This is a test program to study the capability of a GPS module to
   control navigation of a robot in an outdoor environment.
        
   This version is developed within the mbos RTOS:
   http://mbed.org/users/AndrewL/libraries/mbos/lqn3ca
        
   It uses NMEA library by Tim (xtimor@gmail.com) 
   available on public mbed library or http://nmea.sourceforge.net
        
 The original gmath.c has been modified to fix a bug in nmea_distance_ellipsoid() function
 according to bug report ID: 2945855
 
 http://sourceforge.net/tracker/?func=detail&aid=2945855&group_id=192054&atid=939854
 
    // while ((delta_lambda > 1e-12) && (remaining_steps > 0))  original by xtimor
    while (( remaining_steps == 20 ) || ((fabs(delta_lambda) > 1e-12) && (remaining_steps > 0)))
    
 the original code always returns a zero distance if the arrival point longitude
 is equal or smaller than the starting point one.
    
 The mbed module is interfaced with a Garmin GPS sensor (used in standard mode)
 with an external antenna, a 20x4 LCD text display and a 5 keys keypad.
 A curiosity:
 All the hardware components of the test set are mounted on the top of a wooden 
 box, looking like a kind of a steampunk navigator. When my daughter looked at 
 the box she said: "it looks alike the navigator of the da Vinci car".
 This is the reason why the name of this project is "Leonardo".
**
-------------------------------------------------------------------------------
* @copyright 2012 Guido Ottaviani
guido@guiott.com

    LeonardoMbos is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    LeonardoMbos is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with LeonardoMbos.cpp.  If not, see <http://www.gnu.org/licenses/>.
    
-------------------------------------------------------------------------------      
*/
#include "Common.h"
#include "mbed.h"
#include <string>
#include "TextLCD.h"
#include "nmea/nmea.h"
#include <Watchdog.h>
#include "ConfigFile.h"
#include "Init.h" 
#include "Prototype.h"
#include "mbos.h"
#include "Tasks.h"

// Set up RTOS;
mbos os(NUM_TASKS, NUM_TIMERS, NUM_RESOURCES);

int main() 
{
    Initialize();
    if (wd.WatchdogCausedReset())
    {
        pc.printf("Watchdog caused reset**********************************\r\n");
    }
    wd.Configure(WDT_TIMEOUT);       // sets the timeout interval

    os.Start(); // the RTOS starts now
}

//functions =====================================================================

void mbosIdleTask(void)
{/**
 *@brief TASK 0 watchdog kick
 */
 while(1)
 {

 }
}

int CmpRead(void)
{/**
 *@brief Magnetic Compass reading 
 */
    int Cmp;

    // To Be Done
    Cmp = 0; // ************debug
    return(Cmp);
}

void ReadCfg(char *Config[])
{/**
 *@brief Read a configuration file from a mbed filesystem
 */
    char value[BUFSIZ];
    
    if (!cfg.read("/local/input.cfg")) 
    {
        pc.printf("Failure to read a configuration file.\n");
    }
      
    if (cfg.getValue(Config[0], &value[0], sizeof(value))) 
    {
        pc.printf("'%s'='%s'\n", Config[0], value);
    }
 
     if (cfg.getValue(Config[1], &value[0], sizeof(value))) 
    {
        pc.printf("'%s'='%s'\n", Config[1], value);
    }
}

void WriteCfg()
{/**
 *@brief Write configurations to mbed filesystem
 */
     cfg.setValue("LonStart", "lon");
     cfg.setValue("LatStart", "lat");

     cfg.write("/local/input.cfg", "# Configuration file for LeonardoGps.");
 }