#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "SDHCFileSystem.h"
#include "NTPClient.h"

DigitalOut led1(p29, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");

// LocalFileSystem fs("webfs");
SDFileSystem sd(p5, p6, p7, p8, "sd"); // mosi, miso, sclk, cs
       
EthernetNetIf eth
(
  IpAddr(192,168,1,150), //IP Address
  IpAddr(255,255,255,0), //Network Mask
  IpAddr(192,168,1,1), //Gateway
  IpAddr(192,168,1,1)  //DNS
);  

HTTPServer svr;
NTPClient ntp;

int main() {
  Base::add_rpc_class<DigitalOut>();

  FILE *fp = fopen("/sd/myfile.txt", "w"); // to initialize SD
  fprintf(fp, "\n\rHello World!\n\r");
  fclose(fp);

  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
  time_t seconds = time(NULL);
  printf("Current time is (UTC): %s\n", ctime(&seconds));  

  Host server(IpAddr(), 123, "ntp.ien.it");
  ntp.setTime(server);
    
  seconds = time(NULL);  
  printf("\nTime is now (UTC): %s\n", ctime(&seconds)); 
  
  FSHandler::mount("/sd", "/files"); //Mount /webfs path on /files web path
  FSHandler::mount("/sd", "/"); //Mount /webfs path on web root path
  
  svr.addHandler<SimpleHandler>("/hello");
  svr.addHandler<RPCHandler>("/rpc");
  svr.addHandler<FSHandler>("/files");
  svr.addHandler<FSHandler>("/"); //Default handler
  //Example : Access to mbed.htm : http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm
  
  svr.bind(8080);
  
  printf("Listening...\n");
    
  Timer tm;
  tm.start();
  //Listen indefinitely
  while(true)
  {
    Net::poll();
    if(tm.read()>1)
    {
      led1=!led1; //Show that we are alive
      tm.start();
      char buffer[32];
      seconds = time(NULL)+3600;  
      strftime(buffer, 32, "%a %d %b %Y - %H:%M:%S \n", localtime(&seconds));
      printf(" %s", buffer);
    }
  }
  
  return 0;

}
