#include "mbed.h"
#include "main.h"
#include "sx1272-hal.h"
#include "debug.h"
#include "DHT.h"
#include "WakeUp.h"

//glenn
AnalogIn in(PC_3);// Pour la photorésistance
AnalogIn in2(PC_2);// Pour la conductivite

DHT sensor(PC_5,DHT22); // Pour humi/tempe


/*****************************************************
Attention /!\ On récupère la valeur de la résistance et pas des lux
Et aussi on a la valeur du sensor direct, pas de la conductivité exactement
Mettre ça dans la raspberry je pense, ou direct sur le site web
******************************************************/


#define DEBUG_MESSAGE   1

/* Set this flag to '1' to use the LoRa modulation or to '0' to use FSK modulation */
#define USE_MODEM_LORA  1
#define USE_MODEM_FSK   !USE_MODEM_LORA

#define RF_FREQUENCY                                    868000000 // Hz
#define TX_OUTPUT_POWER                                 14        // 14 dBm

#if USE_MODEM_LORA == 1

    #define LORA_BANDWIDTH                              2         // [0: 125 kHz,
                                                                  //  1: 250 kHz,
                                                                  //  2: 500 kHz,
                                                                  //  3: Reserved]
    #define LORA_SPREADING_FACTOR                       7         // [SF7..SF12]
    #define LORA_CODINGRATE                             1         // [1: 4/5,
                                                                  //  2: 4/6,
                                                                  //  3: 4/7,
                                                                  //  4: 4/8]
    #define LORA_PREAMBLE_LENGTH                        8         // Same for Tx and Rx
    #define LORA_SYMBOL_TIMEOUT                         5         // Symbols
    #define LORA_FIX_LENGTH_PAYLOAD_ON                  false
    #define LORA_FHSS_ENABLED                           false  
    #define LORA_NB_SYMB_HOP                            4     
    #define LORA_IQ_INVERSION_ON                        false
    #define LORA_CRC_ENABLED                            true
    
#elif USE_MODEM_FSK == 1

    #define FSK_FDEV                                    25000     // Hz
    #define FSK_DATARATE                                19200     // bps
    #define FSK_BANDWIDTH                               50000     // Hz
    #define FSK_AFC_BANDWIDTH                           83333     // Hz
    #define FSK_PREAMBLE_LENGTH                         5         // Same for Tx and Rx
    #define FSK_FIX_LENGTH_PAYLOAD_ON                   false
    #define FSK_CRC_ENABLED                             true
    
#else
    #error "Please define a modem in the compiler options."
#endif

#define RX_TIMEOUT_VALUE                                3500000   // in us
#define BUFFER_SIZE                                     32        // Define the payload size here

#if( defined ( TARGET_KL25Z ) || defined ( TARGET_LPC11U6X ) )
DigitalOut led(LED2);
#else
DigitalOut led(LED1);
#endif

/*********************************************
// fonction sleep
**********************************************/
/*Timeout timeout;                            // Create the Timeout object
void wait_LowPow(unsigned long time); 
void timer_interrupt()                      // The Timer interrupt service routine
{
                                            // Nothing to do, just for wakeup the system
}
void wait_LowPow(unsigned long time)        // Wait in low power mode function implementation
{
    timeout.attach(&timer_interrupt, time); // Set the timer interrupt service rutine (ISR) and the time for the timeout (in seconds)
    sleep();                                // Enter Low Power Mode (It cant be used deep_sleep() mode, because that mode disable the timer)
}*/

//
/*
 *  Global variables declarations
 */
typedef enum
{
    LOWPOWER = 0,
    IDLE,
    
    RX,
    RX_TIMEOUT,
    RX_ERROR,
    
    TX,
    TX_TIMEOUT,
    
    CAD,
    CAD_DONE
}AppStates_t;

volatile AppStates_t State = LOWPOWER;

/*!
 * Radio events function pointer
 */
static RadioEvents_t RadioEvents;

/*
 *  Global variables declarations
 */
SX1272MB2xAS Radio( NULL );

//const uint8_t PingMsg[] = "PING";
//const uint8_t PongMsg[] = "PONG";
const uint8_t CommandeDebut[] = "1";

/*const uint8_t PingMsg[] = 42;
const uint8_t PongMsg[] = "Message reçu !";*/

uint16_t BufferSize = BUFFER_SIZE;
uint8_t Buffer[BUFFER_SIZE];

int16_t RssiValue = 0.0;
int8_t SnrValue = 0.0;



int main() 
{
    int err;//pour dht22
    //float val_celcius;//dht22
   // float val_humi;//dht22
    uint8_t i;
    bool isMaster = false;
    
    debug( "\n\n\r     SX1272 Ping Pong Demo Application \n\n\r" );

    // Initialize Radio driver
    RadioEvents.TxDone = OnTxDone;
    RadioEvents.RxDone = OnRxDone;
    RadioEvents.RxError = OnRxError;
    RadioEvents.TxTimeout = OnTxTimeout;
    RadioEvents.RxTimeout = OnRxTimeout;
    Radio.Init( &RadioEvents );
    
    
   
     
    //
    
    // verify the connection with the board
    while( Radio.Read( REG_VERSION ) == 0x00  )
    {
        debug( "Radio could not be detected!\n\r", NULL );
        wait( 1 );
    }
            
    debug_if( ( DEBUG_MESSAGE & ( Radio.DetectBoardType( ) == SX1272MB2XAS ) ) , "\n\r > Board Type: SX1272MB2xAS < \n\r" );
  
    Radio.SetChannel( RF_FREQUENCY ); 

#if USE_MODEM_LORA == 1
    
    debug_if( LORA_FHSS_ENABLED, "\n\n\r             > LORA FHSS Mode < \n\n\r");
    debug_if( !LORA_FHSS_ENABLED, "\n\n\r             > LORA Mode < \n\n\r");

    Radio.SetTxConfig( MODEM_LORA, TX_OUTPUT_POWER, 0, LORA_BANDWIDTH,
                         LORA_SPREADING_FACTOR, LORA_CODINGRATE,
                         LORA_PREAMBLE_LENGTH, LORA_FIX_LENGTH_PAYLOAD_ON,
                         LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP, 
                         LORA_IQ_INVERSION_ON, 2000000 );
    
    Radio.SetRxConfig( MODEM_LORA, LORA_BANDWIDTH, LORA_SPREADING_FACTOR,
                         LORA_CODINGRATE, 0, LORA_PREAMBLE_LENGTH,
                         LORA_SYMBOL_TIMEOUT, LORA_FIX_LENGTH_PAYLOAD_ON, 0,
                         LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP, 
                         LORA_IQ_INVERSION_ON, true );
                         
#elif USE_MODEM_FSK == 1

    debug("\n\n\r              > FSK Mode < \n\n\r");
    Radio.SetTxConfig( MODEM_FSK, TX_OUTPUT_POWER, FSK_FDEV, 0,
                         FSK_DATARATE, 0,
                         FSK_PREAMBLE_LENGTH, FSK_FIX_LENGTH_PAYLOAD_ON,
                         FSK_CRC_ENABLED, 0, 0, 0, 2000000 );
    
    Radio.SetRxConfig( MODEM_FSK, FSK_BANDWIDTH, FSK_DATARATE,
                         0, FSK_AFC_BANDWIDTH, FSK_PREAMBLE_LENGTH,
                         0, FSK_FIX_LENGTH_PAYLOAD_ON, 0, FSK_CRC_ENABLED,
                         0, 0, false, true );
                         
#else

#error "Please define a modem in the compiler options."

#endif
     
    debug_if( DEBUG_MESSAGE, "Starting Ping-Pong loop\r\n" ); 
        
    led = 0;
        
    Radio.Rx( RX_TIMEOUT_VALUE );
    wait(1);
    
    union{
            float val_celcius;
            uint8_t array_celcius[4];
        };
        union{
            float res;
            uint8_t array_res[4];
        };
        union{
            float val_humi;
            uint8_t array_humi[4];
        };
        union{
            float val_condu;
            uint8_t array_condu[4];
        };
    
    /*fill le buffer au debut
    */
    for( i = 0; i < BufferSize; i++ )
                        {
                            Buffer[i] = 0;
                        }
    
    WakeUp::calibrate();
    
    while( 1 )
    {
        /***************************************************************************************************
        Declaraction et récupération des données capteurs
        *****************************************************************************************************/
        
        float in_value = in.read();
         res=(10000*in_value)/(3.3 - in_value); // valeur resistance, voir lux après
        float in2_value = in2.read();
         val_condu = in2_value;//Valeur conductivity, voir pour les coef après
       
       debug("la valeur de conductivité du capteur vaut %f\n",val_condu);
        
        err = sensor.readData();  //on lit le dht22
        if (err == 0) {//Valeurs pour dht22
             val_celcius= sensor.ReadTemperature(CELCIUS);
             val_humi= sensor.ReadHumidity();
            printf("Temperature is %4.2f C \r\n",sensor.ReadTemperature(CELCIUS));
            //printf("val_celcius vaut %f\n",val_celcius);
        } else
            printf("\r\nErr %i \n",err);
        
        wait(2);
       /***************************************************************************************************
        On passe les données en uint8_t pour les mettre dans le buffer
        *****************************************************************************************************/
        /****************************************************************************************************
        Test mise en veille
        *****************************************************************************************************/
       /* WakeUp::set_ms(5000);
             //Enter deepsleep, the program won't go beyond this point until it is woken up
                        //sleep(10);
                        //wait_LowPow(10);
                        deepsleep();
                        wait(5);*/
        /***************************************************************************************************
        Les états de Lora
        ***************************************************************************************************/
        switch( State )
        {
        case RX: 
                if( BufferSize > 0 )
                {
                    debug("buffer 0 : %d\n",Buffer[0]);
                    if(Buffer[0] == 1 )
                    {
                        led = !led;
                        debug( "ordre de commencer\r\n" );

                        //Buffer[0,1,2] c'est pour commander les différents appareils. Ici buffer 0
                        Buffer[1]=1;//Ordre pour dire qu'on a bien renvoyer le message
                        // We fill the buffer with numbers for the payload 
                      Buffer[4]=array_res[0];
                        Buffer[5]=array_res[1];
                        Buffer[6]=array_res[2];
                        Buffer[7]=array_res[3];
                        
                        Buffer[8]=array_condu[0];
                        Buffer[9]=array_condu[1];
                        Buffer[10]=array_condu[2];
                        Buffer[11]=array_condu[3];
                        
                        Buffer[12]=array_celcius[0];
                        Buffer[13]=array_celcius[1];
                        Buffer[14]=array_celcius[2];
                        Buffer[15]=array_celcius[3];
                        
                        Buffer[16]=array_humi[0];
                        Buffer[17]=array_humi[1];
                        Buffer[18]=array_humi[2];
                        Buffer[19]=array_humi[3];
                        for( i = 20; i < BufferSize; i++ )
                        {
                            Buffer[i] = i - 20;
                        }
                        
                        Buffer[0]=0;
                        wait_ms( 2000 ); //On attend 2sec c'est pour le dht
                        Radio.Send( Buffer, BufferSize );
                        //On sleep ici
                        //sleep(1000);
                        //sleep();
                        //wait(10);
                       WakeUp::set_ms(3600000);
             //Enter deepsleep, the program won't go beyond this point until it is woken up
                        //sleep(10);
                        //wait_LowPow(10);
                        deepsleep();
                        wait(3600);
                        //debug("fin deepsleep");
                        
                    }
                    else // valid reception but not a PING as expected
                    {    // Set device as master and start again
                        //isMaster = true;
                        Radio.Rx( RX_TIMEOUT_VALUE );
                    }    
                }
            
            State = LOWPOWER;
            break;
        case TX:    
            led = !led; 

            if( isMaster == true )  
            {
                //debug( "Ping...\r\n" );

                //debug("La resistance vaut %f\n",res);
            }
            else
            {
                debug( "Dans tx sans etre le maitre\r\n" );
                debug("La resistance vaut %f\n",res);
            }
            Radio.Rx( RX_TIMEOUT_VALUE );
            State = LOWPOWER;
            break;
        case RX_TIMEOUT:
            if( isMaster == true )
            {
                // Send the next PING frame
                //strcpy( ( char* )Buffer, ( char* )PingMsg );
                for( i = 4; i < BufferSize; i++ )
                {
                    Buffer[i] = i - 4;
                }
                wait_ms( 2000 ); 
                Radio.Send( Buffer, BufferSize );
            }
            else
            {
                Radio.Rx( RX_TIMEOUT_VALUE );  
            }             
            State = LOWPOWER;
            break;
        case RX_ERROR:
            // We have received a Packet with a CRC error, send reply as if packet was correct
            if( isMaster == true )
            {
                // Send the next PING frame
                //strcpy( ( char* )Buffer, ( char* )PingMsg );
                for( i = 4; i < BufferSize; i++ )
                {
                    Buffer[i] = i - 4;
                }
                wait_ms( 2000 );  
                Radio.Send( Buffer, BufferSize );
            }
            else
            {
                // Send the next PONG frame
                //strcpy( ( char* )Buffer, ( char* )PongMsg );
                for( i = 4; i < BufferSize; i++ )
                {
                    Buffer[i] = i - 4;
                }
                wait_ms( 2000 );  
                Radio.Send( Buffer, BufferSize );
            }
            State = LOWPOWER;
            break;
        case TX_TIMEOUT:
            Radio.Rx( RX_TIMEOUT_VALUE );
            State = LOWPOWER;
            break;
        case LOWPOWER:
            break;
        default:
            State = LOWPOWER;
            break;
        } 
       //wait(2);
    }
}

void OnTxDone( void )
{
    Radio.Sleep( );
    State = TX;
    debug_if( DEBUG_MESSAGE, "> OnTxDone\n\r" );
}

void OnRxDone( uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr)
{
    Radio.Sleep( );
    BufferSize = size;
    memcpy( Buffer, payload, BufferSize );
    RssiValue = rssi;
    SnrValue = snr;
    State = RX;
    debug_if( DEBUG_MESSAGE, "> OnRxDone\n\r" );
}

void OnTxTimeout( void )
{
    Radio.Sleep( );
    State = TX_TIMEOUT;
    debug_if( DEBUG_MESSAGE, "> OnTxTimeout\n\r" );
}

void OnRxTimeout( void )
{
    Radio.Sleep( );
    Buffer[ BufferSize ] = 0;
    State = RX_TIMEOUT;
    debug_if( DEBUG_MESSAGE, "> OnRxTimeout\n\r" );
}

void OnRxError( void )
{
    Radio.Sleep( );
    State = RX_ERROR;
    debug_if( DEBUG_MESSAGE, "> OnRxError\n\r" );
}

