#include "header.h"

TS_StateTypeDef TS_State;

void init_cellules(GRILLE G){
	int demarrer=0;
	int x;
	int y;
	int l;
	int h;
	while(demarrer==0){
		Affichagepxl2_debut(G);
		if(TS_State.touchDetected!=0){
			if (TS_State.touchX[0]>Gauche_bouton_demarrer && TS_State.touchY[0]<Bas_bouton_demarrer){
				demarrer=1;
			}
			else{
				x = TS_State.touchX[0],
				y = TS_State.touchY[0];
				l = (x-1)%2 ;
				h = (y-1)%2 ;
				G[l][h]=1;
				Affichagepxl2_debut(G);
			}
		}
		G[10][10]=1;
		G[10][12]=1;
		G[13][10]=1;
		G[14][11]=1;
		G[14][12]=1;
		G[14][13]=1;
		G[11][13]=1;
		G[12][13]=1;
		G[13][13]=1;
		demarrer=1;
	}
}





void Changementetat(GRILLE G, GRILLE Gsomme) //réactualise les états des cases dans G en fonction des cases adjacentes dans Gsomme
{
	int l;
	int h;
	for (l=1; l<LONGUEUR; l++)
	{
		for (h=1; h<HAUTEUR; h++)
		{	
			if (G[l][h]==1)
			{
				if (Gsomme[l][h]<=CVA_VIVANT && Gsomme[l][h]>=CVA_MORT) //condition pour la survie d'une case
				{
					G[l][h]=1;
				}
				else //meurt d'isolement ou d'étouffement
				{
					G[l][h]=0;
				}
			}
			else if (G[l][h]==0)
			{
				if (Gsomme[l][h]==CVA_VIVANT) //passage a l'état vivant si la case est morte
				{
					G[l][h]=1;
				}
				else 
				{
					G[l][h]=0;
				}
			}
		}
	}
}

void Affichagepxl2(GRILLE G) //surtout ne pas confondre les dimensions de l'écran avec les dimension du tableau des cases si on utilise des pixels 2x2 ou plus
{
	int l; //longueur sur G
	int h; //hauteur sur H
	for (l=1; l<LONGUEUR; l+=2)
	{
		for (h=1; h<HAUTEUR; h+=2)
		{	
			int x=(2*l)+1;  //position sur l'écran x,y
			int y=(2*h)+1;
			if (G[l][h]==1){
				BSP_LCD_DrawPixel(x,y,couleurvivante);
				BSP_LCD_DrawPixel(x+1,y,couleurvivante);
				BSP_LCD_DrawPixel(x,y+1,couleurvivante);
				BSP_LCD_DrawPixel(x+1,y+1,couleurvivante);
			}
			else if (G[l][h]==0){
				BSP_LCD_DrawPixel(x,y,couleurmorte);
				BSP_LCD_DrawPixel(x+1,y,couleurmorte);
				BSP_LCD_DrawPixel(x,y+1,couleurmorte);
				BSP_LCD_DrawPixel(x+1,y+1,couleurmorte);
			}
		}
	}
	BSP_LCD_SetTextColor(couleur_stop);
	BSP_LCD_FillRect(400,0,79,60);
	BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
	BSP_LCD_DisplayStringAt(0,0, (uint8_t *)"STOP", RIGHT_MODE);
}

void Affichagepxl2_debut(GRILLE G) 
{
	int l; //longueur sur G
	int h; //hauteur sur H
	for (l=1; l<LONGUEUR; l+=2)
	{
		for (h=1; h<HAUTEUR; h+=2)
		{	
			int x=(2*l)+1;  //position sur l'écran x,y
			int y=(2*h)+1;
			if (G[l][h]==1){
				BSP_LCD_DrawPixel(x,y,couleurvivante);
				BSP_LCD_DrawPixel(x+1,y,couleurvivante);
				BSP_LCD_DrawPixel(x,y+1,couleurvivante);
				BSP_LCD_DrawPixel(x+1,y+1,couleurvivante);
			}
			else if (G[l][h]==0){
				BSP_LCD_DrawPixel(x,y,couleurmorte);
				BSP_LCD_DrawPixel(x+1,y,couleurmorte);
				BSP_LCD_DrawPixel(x,y+1,couleurmorte);
				BSP_LCD_DrawPixel(x+1,y+1,couleurmorte);
			}
		}
	}
	BSP_LCD_SetTextColor(couleur_demarrer);
	BSP_LCD_FillRect(400,0,79,60);
	BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
	BSP_LCD_DisplayStringAt(0,0, (uint8_t *)"START", RIGHT_MODE);
}






void Tabsomme(GRILLE G, GRILLE Gsomme) //réalisation du tableau des sommes a partir du tableau des états
{	
	int l;
	int h;
	for (l=1; l<LONGUEUR; l++)
	{
		for (h=1; h<HAUTEUR; h++)
		{	
			if (l<LONGUEUR && l>0 && h<HAUTEUR && h>0)
			{
				Gsomme[l][h]=SommeADJcorps(G,l,h);
			}
			else if (((l==0)&&(h==HAUTEUR||h==0))||((l==LONGUEUR)&&(h==HAUTEUR||h==0)))
			{
				Gsomme[l][h]=SommeADJcoins(G,l,h);
			}
			else if ((l==0 && (h!=0 && h!=HAUTEUR))||(l==LONGUEUR && (h!=0 && h!=HAUTEUR)))
			{
				Gsomme[l][h]=SommeADJcoteslat(G,l,h);
			}
			else if ((h==0 && (l!=0 && l!=LONGUEUR))||(h==HAUTEUR && (l!=0 && l!=LONGUEUR)))
			{
				Gsomme[l][h]=SommeADJcoteslon(G,l,h);
			}
				
			
		}
	}
}
			
			
int SommeADJcorps(GRILLE G, int i, int h) // sous-fonction de Tabsomme qui gère les cases au centre du tableau (sans les cotés et les coins)
{	
	int s=0;
	s+=(G[i+1][h] + G[i-1][h]);
	s+=(G[i-1][h-1] + G[i][h-1] + G[i+1][h-1]);
	s+=(G[i-1][h+1] + G[i][h+1] + G[i+1][h+1]);
	return s;
}

int SommeADJcoteslat(GRILLE G,int i, int h) // sous-fonction de Tabsomme qui gère les cotés latéraux du tableau
{	
	if (i==0)
		{
		int s=0;
		s+=(G[i][h+1] + G[i][h-1]);
		s+=(G[i+1][h+1] + G[i+1][h-1] + G[i+1][h]);
		s+=(G[LONGUEUR][h+1] + G[LONGUEUR][h-1] + G[LONGUEUR][h]);
		return s; 
	}
	if (i==LONGUEUR)
		{
		int s=0;
		s+=(G[i][h+1] + G[i][h-1]);
		s+=(G[i-1][h+1] + G[i-1][h-1] + G[i-1][h]);
		s+=(G[0][h+1] + G[0][h-1] + G[0][h]);
		return s;
	}
	return 0;
}

int SommeADJcoteslon(GRILLE G,int i, int h)// sous-fonction de Tabsomme qui gère les cotés en longueur du tableau
{	
	if (h==0)
		{
		int s=0;
		s+=(G[i+1][h] + G[i-1][h]);
		s+=(G[i-1][h+1] + G[i][h+1] + G[i+1][h+1]);
		s+=(G[i-1][HAUTEUR] + G[i][HAUTEUR] + G[i+1][HAUTEUR]);
		return s; 
	}
	if (h==HAUTEUR)
		{
		int s=0;
		s+=(G[i+1][h] + G[i-1][h]);
		s+=(G[i-1][h+1] + G[i][h+1] + G[i+1][h+1]);
		s+=(G[i-1][0] + G[i][HAUTEUR] + G[i+1][HAUTEUR]);
		return s;
	}
	return 0;
}
	

int SommeADJcoins(GRILLE G, int i, int h) // sous-fonction de Tabsomme qui gère les coins du tableaux
{
	int s=0;
	if (i==0)
		{
		if (h==0) //coin sup gauche
			{
			s+=(G[LONGUEUR][HAUTEUR]);
			s+=(G[1][0] + G[1][1] + G[0][1]);
			s+=(G[LONGUEUR][0] + G[LONGUEUR][1]);
			s+=(G[0][HAUTEUR] + G[1][HAUTEUR]);
			return s;
		}
		else if (h==HAUTEUR) //coin inf gauche
			{
			s+=(G[LONGUEUR][0]);
			s+=(G[0][HAUTEUR - 1] + G[1][HAUTEUR - 1] + G[1][HAUTEUR]);
			s+=(G[LONGUEUR][HAUTEUR -1] + G[LONGUEUR][HAUTEUR]);
			s+=(G[0][0] + G[1][0]);
			return s;
		}
	}
	else if (i==LONGUEUR)
		{
		if (h==0) //coin sup droit
			{
			s+=(G[0][HAUTEUR]);
			s+=(G[LONGUEUR - 1][0] + G[LONGUEUR - 1][0] + G[LONGUEUR - 1][1]);
			s+=(G[LONGUEUR][HAUTEUR] + G[LONGUEUR-1][HAUTEUR]);
			s+=(G[0][0] + G[0][1]);
			return s;
		}
		else if (h==HAUTEUR) //coin inf droit
			{
			s+=(G[0][0]);
			s+=(G[LONGUEUR - 1][HAUTEUR] + G[LONGUEUR - 1][HAUTEUR - 1] + G[LONGUEUR][HAUTEUR - 1]);
			s+=(G[LONGUEUR][0] + G[LONGUEUR - 1][0]);
			s+=(G[0][HAUTEUR] + G[0][HAUTEUR - 1]);
			return s;
		}
	}
	return 0;
}



void partie(GRILLE G,GRILLE Gsomme){
	int stop=0;
	while(stop==0){
		Tabsomme(G,Gsomme);
		Changementetat(G,Gsomme);
		Affichagepxl2(G);
		if(TS_State.touchDetected != 0){
			if (TS_State.touchX[0]>Gauche_bouton_demarrer && TS_State.touchY[0]<Bas_bouton_demarrer){
				stop=1;
			}
		}
		HAL_Delay(TEMPS_TOUR);
	}
}




int fin_de_partie(GRILLE G,GRILLE Gsomme){
	int rejouer=0;
	int continuer=0;
	BSP_LCD_SetTextColor(couleur_stop);
	BSP_LCD_FillRect(400,0,79,60);
	BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
	BSP_LCD_DisplayStringAt(0,0, (uint8_t *)"NEW TRY", RIGHT_MODE);
	BSP_LCD_SetTextColor(couleur_demarrer);
	BSP_LCD_FillRect(0,0,79,60);
	BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
	BSP_LCD_DisplayStringAt(0,0, (uint8_t *)"CONTINUE", LEFT_MODE);
	while(rejouer==0||continuer==0){
		if(TS_State.touchDetected!=0){
			if (TS_State.touchX[0]>Gauche_bouton_demarrer && TS_State.touchY[0]<Bas_bouton_demarrer){
				rejouer=1;
			}
			else if (TS_State.touchX[0]<Droit_bouton_continuer && TS_State.touchY[0]<Bas_bouton_demarrer){
				continuer=1;
			}
		}
	}
	if (continuer==1){
		partie(G,Gsomme);
		fin_de_partie(G,Gsomme);
	}
	return rejouer;
}












