/*Librairie de Lecture et de calibration des capteurs de PH, Tempèrature, Oxymètrie et conductimètire .
 *Nyl Cordon Polytech grenoble 2019. 
 *Projet collectif de la serre Bioponique de polytech grenoble. 
 *
 */
 
#ifndef CAPTEUR_H
#define CAPTEUR_H

#include "mbed.h"
#define EZO_DO (0x61<<1) //97: adresse du registre I2C de la lecture capteur Oxymètrie
#define EZO_pH (0x63<<1)//99 : adresse du registre I2C de la lecture capteur PH-metrie
#define EZO_EC (0x64<<1)//100 : adresse du registre I2C de la lecture capteur de conductivité
#define EZO_RTD (0x66<<1)//102 : adresse du registre I2C de la lecture capteur de tempèrature


class capteur
{
public:
    public:
        capteur(PinName sda, PinName scl);
        void code (int code);
/*fonction d'affichage des valeurs mesurés*/
        void affich_DO (void);
        void affich_EC (void);
        void affich_pH (void);
        void affich_temp (void);
/*fonction qui retourne la chaine de caractère correspondant au valeurs mesurés*/        
        char* return_temp (void);
        char* return_DO (void);
        char* return_EC (void);
        char* return_pH (void);
/*fonction permettant la calibration des capteurs*/
        void calibrate_temp(const char* );
        void calibrate_EC(void);
        void calibrate_pH(void);
        void calibrate_DO(void);
    private:
        I2C i2c;
        char res[30];
        char res_ph[400];
        char res_ec[400];
        char res_do[30];  
};
#endif //CAPTEUR_H