/* Code permettant de définir les adresse neccessaire pour la comunication en OTAA ou en ABP
OTTA:
    -LORAWAN_DEVICE_EUI                         
    -LORAWAN_APPLICATION_EUI                     
    -LORAWAN_APPLICATION_KEY  
APB:
    -Device EUI
    -Application EUI
    -Device Address
    -Network Session Key
    -App Session Key
Pour se connecter au LoRaServeur de L'UGA(contacter didier Didier Donsez) ou avec The Thing Network(service gratuit)
*/
/*----------------------------------------------*/
/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: End device commissioning parameters

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
#ifndef __LORA_COMMISSIONING_H__
#define __LORA_COMMISSIONING_H__

/*!
 * When set to 1 the application uses the Over-the-Air activation procedure
 * When set to 0 the application uses the Personalization activation procedure
 */
#define OVER_THE_AIR_ACTIVATION                     1

/*!
 * Indicates if the end-device is to be connected to a private or public network
 */
#define LORAWAN_PUBLIC_NETWORK                      true

/*!
 * IEEE Organizationally Unique Identifier ( OUI ) (big endian)
 * \remark This is unique to a company or organization
 */
#define IEEE_OUI                                    0x11, 0x22, 0x23

/*!
 * Mote device IEEE EUI (big endian)
 */
#define LORAWAN_DEVICE_EUI                          { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 }

/*!
 * Application IEEE EUI (big endian)
 */
#define LORAWAN_APPLICATION_EUI                     { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 }

/*!
 * AES encryption/decryption cipher application key
 */
#define LORAWAN_APPLICATION_KEY                     { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 }

/*!
 * Current network ID
 */
#define LORAWAN_NETWORK_ID                          ( uint32_t )0

/*!
 * Device address on the network (big endian)
 */
#define LORAWAN_DEVICE_ADDRESS                      ( uint32_t )0x260115E8

/*!
 * AES encryption/decryption cipher network session key
 */
#define LORAWAN_NWKSKEY                             { 0x99, 0x9A, 0xD8, 0xAF, 0x5F, 0x5F, 0xA5, 0x75, 0x24, 0x9A, 0xC4, 0x62, 0x0D, 0xD0, 0xDF, 0xAB }
/*!
 * AES encryption/decryption cipher application session key
 */
#define LORAWAN_APPSKEY                             { 0x11, 0x29, 0xCB, 0x33, 0x8E, 0xDE, 0x39, 0x86, 0x56, 0x7C, 0x63, 0xA0, 0x41, 0xAC, 0x20, 0x6D }
#endif // __LORA_COMMISSIONING_H__
