#include "mbed.h"
#include "Checksum.h"
#include "hc12.h"


hc12::hc12()
{
   RawSerial MODULOHC(PTE0,PTE1);
    MODULOHC.attach(this,&hc12::llegan_datos);
    vector_envio[0]='<';
    vector_envio[1]='V';
    vector_envio[3]='A';
    vector_envio[5]='F';
    vector_envio[7]='C';
    vector_envio[10]='>';
    datos=CASO_1;

    tramamal=0;
    llegomal=0;
    llegobien=0;
    newdata = 0;
}

void hc12::update_parameters(char speed,char dist,char ejex,char ejey,char bateria)
{
    vector_envio[2]=speed;
    vector_envio[4]=dist; //en mm
    vector_envio[6]=ejex;
    vector_envio[7]=ejey;
    vector_envio[9]=bat;//porcetaje
    vector_envio[11]=checksum.get_xor(vector_envio, 11);
   MODULOHC.printf("<S%dD%dE%d%dB%d%d>",speed,dist,ejex,ejey,bat,vector_envio[11]);
    NoLlegaNada.attach(this,&hc12::noentrandatos,0.1);

}


void hc12::llegan_datos()
{
    NoLlegaNada.detach();
    c = MODULOHC.getc();
    newdata = 1;
    maquina_datos();
    if(llegomal!=0) {
        tramamal++; //PONER QUE SI SE HACE CONSTANTE QUE LAS TRAMAS LLEGUEN MAL AVISE
    }
}

void hc12::maquina_datos()
{
    switch (datos) {
        case CASO_1:
            if(newdata==1 && c=='<') {
                newdata=0;
                vector_datos[0]='<';
                datos=CASO_S;
            } else if(newdata==1 && c!='<') {//poner para que termine
                llegomal++;
            }
            break;

        case CASO_S:
            if(newdata==1 && c=='V') {
                vector_datos[1]='V';
                datos=CASO_SA;
                newdata=0;
            } else if(newdata==1 && c!='V') {
                llegomal++;
                datos=CASO_1;
            }
            break;

        case CASO_SA:
            if(newdata==1) {
                vector_datos[2]=c;
                datos=CASO_D;
                newdata=0;
            }
            break;

        case CASO_D:
            if(newdata==1 && c=='A') {
                vector_datos[3]='A';
                newdata=0;
                datos=CASO_DA;
            } else if(newdata==1 && c!='A') {
                llegomal++;
                datos=CASO_1;
            }
            break;

        case CASO_DA:
            if(newdata==1) {
                vector_datos[4]=c;
                newdata=0;
                datos=CASO_E;
            }
            break;

        case CASO_E:
            if(newdata==1 && c=='F') {
                vector_datos[5]='F';
                newdata=0;
                datos=CASO_EA;
            } else if(newdata==1 && c!='F') {
                llegomal++;
                datos=CASO_1;
            }
            break;

        case CASO_EA:
            if(newdata==1) {
                vector_datos[6]=c;
                newdata=0;
                datos=CASO_B;
            }
            break;

        case CASO_B:
            if(newdata==1 && c=='C') {
                vector_datos[7]='C';
                newdata=0;
                datos=CASO_BA;
            } else if(newdata==1 && c!='C') {
                llegomal++;
                datos=CASO_1;
            }
            break;

        case CASO_BA:
            if(newdata==1) {
                vector_datos[8]=c;
                newdata=0;
                datos=CASO_CHECK;
            }
            break;

        case CASO_CHECK:
            check=checksum.get_xor(vector_datos, 10);//hasta que numero kevinnn
            if(newdata==1) {
                vector_datos[9]=c;
                newdata=0;
                if(check==vector_datos[9]) {
                    llegobien=1;
                    datos=CASO_FIN;
                } else if{
                datos=CASO_1;
            }
        }
        break;

    case CASO_FIN:
        if(newdata==1 && c=='>') {
                vector_datos[10]='>';
                newdata=0;
                if(llegobien==1) {
                    for(char i=0; i<=10; i++) {
                        pc.printf("%c\n",vector_datos[i]);
                    }
                    llegobien=0;
                    llegomal=0;
                    tramamal=0;
                    volante=vector_datos[2];
                    acelerador=vector_datos[4];
                    freno=vector_datos[6];
                    cambios=vector_datos[8];
                }
            } else if(newdata==1 && c!='>') {
                llegomal++;
            }
            datos=CASO_1;
            break;
    }
}
int hc12::get_break_pedal()
{
    return freno;
}

int hc12::get_speed_pedal()
{
    return acelerador;
}

int hc12::get_changes()
{
    return cambios;
}
int hc12::get_steering_wheel()
{
    return volante;
}
void hc12::noentrandatos()
{
    MODULOHC.printf("<S%dD%dE%d%dB%d%d>",speed,distancia,ejex,ejey,vector_envio[11]);
}