#include "mbed.h"
#include "tsi_sensor.h"

#define INICIO 0
#define RW 1
#define DISP 2
#define DISP_W 3
#define DISP_R 4
#define EST 5
#define VERIF 6
#define FIN 7
#define PWMD 8
#define PWMU 9

/* Cosas del TSI */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif

//Definimos que el puerto serie se llama pc
Serial pc(USBTX, USBRX);

//Variable donde se guarda lo recibido
unsigned char   c = '\0';

unsigned char slider=0, pote=0, verif;

//bit usado como flag para procesar datos
bool newdata = false;   //Se pone en true cuando hay nuevos datos
bool ejec = false;   //Se pone en true cuando hay una trama correcta
unsigned char rec[7]= {0};

//Creamos los tres leds pra usar
DigitalIn bt1(PTA4,PullUp);
DigitalIn bt2(PTA5,PullUp);
DigitalOut LR(LED1);
DigitalOut LG(LED2);
DigitalOut LB(LED3);
AnalogIn analo(PTB0);
AnalogOut pwm (PTE30);

//Callback cuando se detecta una entrada
void onCharReceived()
{
    //Copiamos lo leido en c
    c = pc.getc();
    newdata = true;
}

bool recibiendo(void)
{
    static unsigned char est=INICIO;
    switch(est) {
        default:
        case INICIO:
            if (c=='$') { //Si $ lo guardo en el char 0 de rec
                rec[0]=c;
                est=RW;
            }
            //Hacemos NULL c para que no vuelva a ejecutar
            c = '\0';
            break;

        case RW:
            if ((c=='W')||(c=='R')) { //Si W o R lo guardo en el char 1 de rec

                rec[1]=c;
                est=DISP;
            }   else    {
                if(c=='P') {
                    rec[1]=c;
                    est=PWMD;
                }   else    {
                    if(c=='$') {
                        rec[0]=c;
                        rec[1]=0;
                        rec[2]=0;
                        rec[3]=0;
                        rec[4]=0;
                        rec[5]=0;
                        rec[6]=0;
                        est=RW;
                    } else {
                        rec[0]=0;
                        rec[1]=0;
                        rec[2]=0;
                        rec[3]=0;
                        rec[4]=0;
                        rec[5]=0;
                        rec[6]=0;
                        est=INICIO;
                    }
                }
            }
            //Hacemos NULL c para que no vuelva a ejecutar
            c = '\0';
            break;

        case DISP:
            if ((rec[1]=='R')&&((c=='L')||(c=='A')||(c=='D'))) { //Si leo y recibo L, A o D lo guardo en el char 2 de rec
                rec[2]=c;
                est=DISP_R;
            } else {
                if ((rec[1]=='W')&&(c=='L')) { //Si escribo y recibo L lo guardo en el char 2 de rec
                    rec[2]=c;
                    est=DISP_W;
                }   else    {
                    if(c=='P') {
                        rec[2]=c;
                        rec[3]=0;
                        rec[4]=0;
                        est=VERIF;
                    } else {
                        if(c=='$') {
                            rec[0]=c;
                            rec[1]=0;
                            rec[2]=0;
                            rec[3]=0;
                            rec[4]=0;
                            rec[5]=0;
                            rec[6]=0;
                            est=RW;
                        } else {
                            rec[0]=0;
                            rec[1]=0;
                            rec[2]=0;
                            rec[3]=0;
                            rec[4]=0;
                            rec[5]=0;
                            rec[6]=0;
                            est=INICIO;
                        }
                    }
                }
            }
            //Hacemos NULL c para que no vuelva a ejecutar
            c = '\0';
            break;

        case DISP_W:
            if ((c=='R')||(c=='G')||(c=='B')) { //Si escribo y recibo G, B o R lo guardo en el char 3 de rec
                rec[3]=c;
                est=EST;
            }   else    {
                if(c=='$') {
                    rec[0]=c;
                    rec[1]=0;
                    rec[2]=0;
                    rec[3]=0;
                    rec[4]=0;
                    rec[5]=0;
                    rec[6]=0;
                    est=RW;
                } else {
                    rec[0]=0;
                    rec[1]=0;
                    rec[2]=0;
                    rec[3]=0;
                    rec[4]=0;
                    rec[5]=0;
                    rec[6]=0;
                    est=INICIO;
                }
            }
            c=0;
            break;

        case DISP_R:
            if ((c=='1')||(c=='2')||(c=='3')) { //Si leo y recibo 1 o 2 lo guardo en el char 3 de rec
                rec[3]=c;
                rec[4]=0;
                est=VERIF;
            }   else    {
                if(c=='$') {
                    rec[0]=c;
                    rec[1]=0;
                    rec[2]=0;
                    rec[3]=0;
                    rec[4]=0;
                    rec[5]=0;
                    rec[6]=0;
                    est=RW;
                } else {
                    rec[0]=0;
                    rec[1]=0;
                    rec[2]=0;
                    rec[3]=0;
                    rec[4]=0;
                    rec[5]=0;
                    rec[6]=0;
                    est=INICIO;
                }
            }
            //Hacemos NULL c para que no vuelva a ejecutar
            c=0;
            break;

        case EST:
            if ((c=='1')||(c=='0')) { //Si escribo y recibo 1 o 0 lo guardo en el char 4 de rec
                rec[4]=c;
                est=VERIF;
            }   else    {
                if(c=='$') {
                    rec[0]=c;
                    rec[1]=0;
                    rec[2]=0;
                    rec[3]=0;
                    rec[4]=0;
                    rec[5]=0;
                    rec[6]=0;
                    est=RW;
                } else {
                    rec[0]=0;
                    rec[1]=0;
                    rec[2]=0;
                    rec[3]=0;
                    rec[4]=0;
                    rec[5]=0;
                    rec[6]=0;
                    est=INICIO;
                }
            }
            //Hacemos NULL c para que no vuelva a ejecutar
            c=0;
            break;

        case VERIF:
            if(c==verif) {
                rec[5]=c;//Guarda la verificacion de la trama en rec 5
                est=FIN;
            }   else    {
                if(c=='$') {
                    rec[0]=c;
                    rec[1]=0;
                    rec[2]=0;
                    rec[3]=0;
                    rec[4]=0;
                    rec[5]=0;
                    rec[6]=0;
                    est=RW;
                } else {
                    rec[0]=0;
                    rec[1]=0;
                    rec[2]=0;
                    rec[3]=0;
                    rec[4]=0;
                    rec[5]=0;
                    rec[6]=0;
                    est=INICIO;
                }
            }
            c=0;
            break;

        case FIN:
            if(c=='!') { //Si recibo !0 lo guardo en el char 6 de rec
                rec[6]=c;
                est=INICIO;
                //Hacemos NULL c para que no vuelva a ejecutar
                c=0;
                return (true);
            }   else    {
                if((c=='$')||((rec[5]=='$')&&((c=='W')||(c=='R')))) {
                    if(c=='$') {
                        rec[0]='$';
                        rec[1]=0;
                        rec[2]=0;
                        rec[3]=0;
                        rec[4]=0;
                        rec[5]=0;
                        rec[6]=0;
                        est=RW;
                    } else {
                        rec[0]='$';
                        rec[1]=c;
                        rec[2]=0;
                        rec[3]=0;
                        rec[4]=0;
                        rec[5]=0;
                        rec[6]=0;
                        est=DISP;
                    }
                } else {
                    rec[0]=0;
                    rec[1]=0;
                    rec[2]=0;
                    rec[3]=0;
                    rec[4]=0;
                    rec[5]=0;
                    rec[6]=0;
                    est=INICIO;
                }
            }
            //Hacemos NULL c para que no vuelva a ejecutar
            c=0;
            break;

        case PWMD:
            if ((c>='0')&&(c<='9')) { //Si recibo de 0 a 9 o de A a F lo guardo en el char 2 de rec
                rec[2]=c;
                est=PWMU;
            }   else    {
                if(c=='$') {
                    rec[0]=c;
                    rec[1]=0;
                    rec[2]=0;
                    rec[3]=0;
                    rec[4]=0;
                    rec[5]=0;
                    rec[6]=0;
                    est=RW;
                } else {
                    rec[0]=0;
                    rec[1]=0;
                    rec[2]=0;
                    rec[3]=0;
                    rec[4]=0;
                    rec[5]=0;
                    rec[6]=0;
                    est=INICIO;
                }
            }
            //Hacemos NULL c para que no vuelva a ejecutar
            c=0;
            break;
        case PWMU:
            if (((c>='0')&&(c<='9'))||((c>='A')&&(c<='F'))) { //Si recibo de 0 a 9 o de A a F lo guardo en el char 2 de rec
                rec[3]=c;
                est=VERIF;
            }   else    {
                if(c=='$') {
                    rec[0]=c;
                    rec[1]=0;
                    rec[2]=0;
                    rec[3]=0;
                    rec[4]=0;
                    rec[5]=0;
                    rec[6]=0;
                    est=RW;
                } else {
                    rec[0]=0;
                    rec[1]=0;
                    rec[2]=0;
                    rec[3]=0;
                    rec[4]=0;
                    rec[5]=0;
                    rec[6]=0;
                    est=INICIO;
                }
            }
            //Hacemos NULL c para que no vuelva a ejecutar
            c=0;
            break;
    }
    return (false);
}

void interpretacion(void)
{
    static unsigned char aux, aux2, aux3;
    if(rec[1]=='W') {
        if(rec[3]=='R') {
            if(rec[4]=='1')
                LR=0;
            if(rec[4]=='0')
                LR=1;
            printf("\n$RL1%d!\r\n",!LR);
        }
        if(rec[3]=='B') {
            if(rec[4]=='1')
                LB=0;
            if(rec[4]=='0')
                LB=1;
            printf("\n$RL3%d!\r\n",!LB);
        }
        if(rec[3]=='G') {
            if(rec[4]=='1')
                LG=0;
            if(rec[4]=='0')
                LG=1;
            printf("\n$RL2%d!\r\n",!LG);
        }

    }
    if(rec[1]=='R') {
        if(rec[2]=='L') {
            if(rec[3]=='1')
                printf("\n$RL1%d!\r\n",!LR);
            if(rec[3]=='2')
                printf("\n$RL2%d!\r\n",!LG);
            if(rec[3]=='3')
                printf("\n$RL3%d!\r\n",!LB);
        }
        if(rec[2]=='A') {
            if(rec[3]=='1')
                printf("\n$RA1%02X!\r\n",slider);
            if(rec[3]=='2')
                printf("\n$RA2%02X!\r\n",pote);
        }
        if(rec[2]=='D') {
            if(rec[3]=='1')
                printf("\n$RD1%d!\r\n",!bt1);
            if(rec[3]=='2')
                printf("\n$RD2%d!\r\n",!bt2);
        }
        if(rec[2]=='P') {
            aux = pwm*100;
            printf("\n$P%02X!\r\n", aux);
        }
    }
    if (rec[1]=='P') {
        if (rec[3]>='A')
            aux3 = rec[3]-'A'+10;
        else
            aux3 = rec[3]-'0';
        aux2 = (16*(rec[2]-'0'))+aux3;
        pwm = (float) aux2/100;
        printf("\n$P%02X!\r\n", aux2);
    }
}

int main()
{
//Apagamos los leds
    LG=1;
    LR=1;
    LB=1;

    pwm=1;

    TSIAnalogSlider tsi(ELEC0, ELEC1, 40);

//Ejecutar onCharReceived por cada entrada por puerto
    pc.attach(&onCharReceived);

    while (true) {
        verif=rec[1]^rec[2]^rec[3];
        slider=255*tsi.readPercentage();
        pote=255*analo.read();
        if(newdata) {
            ejec=recibiendo();
            newdata = false;
        }
        if(ejec) {
            interpretacion();
            ejec=0;
        }
    }
}