
#include "mbed.h"
#include "tsi_sensor.h"
#include <Dht11.h>
/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif
// ENTRADAS Y SALIDAS
DigitalOut led_rojo(LED_RED);
DigitalOut led_verde(LED_GREEN);
DigitalOut led_azul(LED_BLUE);
AnalogIn preset_abierto(PTB1);//PRESET LAZO ABIERTO
PwmOut velocidad_cooler(PTB0);//COOLER
DigitalIn medidor_rpm(PTB8); //SENSOR EFECTO HALL
Dht11 sensor(PTB2);
//VALORES NECESARIOS
#define VELOCIDAD_MAX 7500 //MAXIMA VELOCIDAD QUE ALCANZA EL COOLER
#define VOLTAJE_MIN 0.06 //VOLTAJE QUE SE NECESITA PARA LOS 200 RPM
#define RPM_MIN 360
#define TEMP_MAX 40
#define TEMP_MIN 10
//TIMERS
Ticker timer1;
Timer t;

//FUNCIONES
void revoluciones();
void boton_puls();
void valor_preset();
void tiempo();
void func_temp();

//ESTADOS
enum {INICIO,CUENTA,ESPERO_PULS,LAZO_ABIERTO,LAZO_CERRADO,CV1,CV2,CV3,DECRECE_CERRADO,CRECE_CERRADO,APRETAR,SOLTAR,ESPERO,ESPERO2,FIN_PERIODO,CONTEO};

//VARIABLES
float preset,vel=0.5;
int rpm=0,pulsos=0,velocidad;
char tiempo1=0,tiempo4=0,tiempo3=10,modo=INICIO,temp,conversion=0;

//CONFIG TSI
TSIAnalogSlider tsi(ELEC0, ELEC1, 40);

int main()
{
    timer1.attach(&tiempo,0.1);
    medidor_rpm.mode(PullUp);//PULLUP
    while(1) {
        valor_preset(); //FUNCIONES DEL PROGRAMA
        revoluciones();
        boton_puls();
        func_temp();
        /* printf("%i\n",rpm);*/
        switch(modo) {
            default:
            case INICIO://SE PRENDEN LOS LEDS DE INICIO
                led_azul=1;
                led_verde=0;
                led_rojo=1;
                break;
            case LAZO_ABIERTO:
                if(tiempo4==0) {//TIEMPO PARA SETEAR PWM
                    velocidad_cooler.write(preset);
                    tiempo4=1;
                }
                //APRETANDO EL TSI SE CAMBIA DE MODO A LAZO CERRADO
                break;
            case LAZO_CERRADO:
                if(temp<TEMP_MIN)modo=CV1;//CASO PARA TEMPERATURA MENOR AL MINIMO
                if((temp<TEMP_MAX)&&(temp>TEMP_MIN))modo=CV2;//CASO PARA TEMPERATURA ENTRE EL MINIMO Y MAXIMO
                if(temp>TEMP_MAX)modo=CV3;//CASO PARA TEMPERATURA AL MAXIMO
                //APRETANDO EL TSI SE CAMBIA DE MODO A LAZO ABIERTO
                break;
            case CV1:
                velocidad=RPM_MIN;//SETEO DE RPM MIN
                if(rpm<(velocidad+100))modo=CRECE_CERRADO;//EN CASO DE QUE LOS RPM BAJEN AL VALOR SETEADO
                if(rpm>(velocidad-100))modo=DECRECE_CERRADO;//EN CASO DE QUE LOS RPM SUBAN AL VALOR SETEADO (SE COLOCA UN RANGO PERMITIDO DE +-100RPM)
                break;
            case CV2:
                velocidad=RPM_MIN+((temp-TEMP_MIN)*((VELOCIDAD_MAX-RPM_MIN)/(TEMP_MAX-TEMP_MIN)));//SETEO DE RPM SEGUN TEMPERATURA
                if(rpm<(velocidad+100))modo=CRECE_CERRADO;
                if(rpm>(velocidad-100))modo=DECRECE_CERRADO;
                break;
            case CV3:
                velocidad=VELOCIDAD_MAX;
                if(rpm<(velocidad+100))modo=CRECE_CERRADO;
                if(rpm>(velocidad-100))modo=DECRECE_CERRADO;
                break;
            case DECRECE_CERRADO:
                if(rpm<=(velocidad+100)) {//SE SALE DEL MODO UNA VEZ SE ALCANCE EL VALOR REQUERIDO
                    modo=LAZO_CERRADO;
                    break;
                }
                if(conversion==1) {// PERMITE DISMINUIR LA VELOCIDAD SOLO DESPUES DE HABER MEDIDO LOS RPM
                    conversion=0;
                    if(vel>0.01)vel=vel-0.01;//CHEQUEA QUE NO SE ENCUENTRE EN EL MINIMO
                    else vel=0;
                    velocidad_cooler.write(vel);//SE SETEA LA VELOCIDAD CORREGIDA
                }
                break;
            case CRECE_CERRADO:
                if(rpm>=(velocidad-100)) {//SE SALE DEL MODO UNA VEZ SE ALCANCE EL VALOR REQUERIDO
                    modo=LAZO_CERRADO;
                    break;
                }
                if(conversion==1) {// PERMITE AUMENTAR LA VELOCIDAD SOLO DESPUES DE HABER MEDIDO LOS RPM
                    conversion=0;
                    if(vel<0.99)vel=vel+0.01;//CHEQUEA QUE NO SE ENCUENTRE EN EL MAXIMO
                    else vel=1;
                    velocidad_cooler.write(vel);//SE SETEA LA VELOCIDAD CORREGIDA
                }

                break;
        }
    }
}
void  valor_preset()
{
    if(preset_abierto<= VOLTAJE_MIN)preset=VOLTAJE_MIN;//SE FIJA LA VELOCIDAD MINIMA DEL COOLER EN LAZO ABIERTO
    else preset=preset_abierto;
}
void boton_puls()
{
    static char modo_local1=APRETAR;
    switch(modo_local1) {
        default:
        case APRETAR:
            if(tsi.readPercentage()!=0)modo_local1=SOLTAR;//SE APRIETA EL TSI Y SE ESPERA A SOLTARLO
            break;
        case SOLTAR:
            if(tsi.readPercentage()==0) {
                modo_local1=APRETAR;
                if(modo==LAZO_ABIERTO) {//SE CAMBIA AL MODO CONTRARIO QUE SE ENCUENTRA ACTIVO
                    led_azul=0;
                    led_rojo=1;
                    modo=LAZO_CERRADO;
                } else {
                    modo=LAZO_ABIERTO;
                    led_azul=1;
                    led_rojo=0;
                }
            }
            break;
    }
}
void revoluciones()
{
    static char modo_local=CUENTA;
    static int pulsos=0;
    switch(modo_local) {
        case CUENTA:
            rpm=pulsos*60;//SE HACE LA CUENTA PARA SABER LA CANTIDAD RPM
            conversion=1;//INDICADOR DE FINALIZACION DE CONVERSION
            printf("RPM COOLER= %i,PORCENTAJE DE PRESET= %.2f,VEL ACTUAL= %.2f,VEL SETEADA=%i,TEMP=%i,\n",rpm,preset*100,vel,velocidad,temp);
            tiempo3=10;//TIEMPO ENTRE CADA SENSADO
            pulsos=0;
            modo_local=ESPERO;
            break;
        case ESPERO:
            if(tiempo3==0)modo_local=CUENTA;//CUANDO FINALIZA EL TIEMPO DE SENSADO 
            else {
                if(medidor_rpm==1) {
                    modo_local=ESPERO_PULS;
                    pulsos++;
                }
            }
        case ESPERO_PULS:
            if(medidor_rpm==0)modo_local=ESPERO;
            if(tiempo3==0)modo_local=CUENTA;
            break;
    }
}
void func_temp()
{
    if(tiempo1==0) {
        sensor.read();     //SE LEE LA TEMPERATURA
        temp=sensor.getCelsius();//SE ASIGNA EL VALOR DE TEMPERATURA A UNA VARIABLE
        tiempo1=50;//TIEMPO ENTRE CADA LECTURA DE TEMPERATURA 5 SEGUNDOS
        tiempo3=10;//REINICIA TIEMPO MEDICION RPM EN CASO DE HABER INTERRUMPIDO
        pulsos=0;//REINICIA PULSOS
    }
}
void tiempo()
{
    if(tiempo1!=0)tiempo1--;
    if(tiempo3!=0)tiempo3--;
    if(tiempo4!=0)tiempo4--;
}
