#include "mbed.h"
#include "Camera_LS_Y201.h"
//#include <string.h>
//#include "GPS.h"
#define DEBMSG      printf
#define NEWLINE()   printf("\r\n")

#define BUFF_SIZE  32
#define USE_SDCARD 0


#if USE_SDCARD
#define FILENAME    "/sd/IMG_%04d.jpg"
//SDFileSystem fs(p5, p6, p7, p8, "sd");
#else
#define FILENAME    "/local/ALT%d_%02d.jpg"
LocalFileSystem fs("local");
#endif
Camera_LS_Y201 cam1(p28, p27);
#define DEPTH 5
//GPS gps(p9,p10);
Serial gsm(p13,p14);
Serial pc(USBTX,USBRX);
AnalogIn motion(p15);

 float reading; 
 int alert_num = 0;
 char phone_num[11];

typedef struct work {
    FILE *fp;
} work_t;

work_t work;

/**
 * Callback function for readJpegFileContent.
 *
 * @param buf A pointer to a buffer.
 * @param siz A size of the buffer.
 */
void callback_func(int done, int total, uint8_t *buf, size_t siz) 
{
    fwrite(buf, siz, 1, work.fp);

}


/**
 * Capture.
 *
 * @param cam A pointer to a camera object.
 * @param filename The file name.
 *
 * @return Return 0 if it succeed.
 */
int capture(Camera_LS_Y201 *cam, char *filename) 
{
    /*
     * Take a picture.
     */
    if (cam->takePicture() != 0) {
        return -1;
    }
    //DEBMSG("Captured.");
    //NEWLINE();

    /*
     * Open file.
     */
    work.fp = fopen(filename, "wb");
    if (work.fp == NULL) {
        return -2;
    }

    /*
     * Read the content.
     */
    //DEBMSG("%s", filename);
    //NEWLINE();
    if (cam->readJpegFileContent(callback_func) != 0) 
    {
        fclose(work.fp);
        return -3;
    }
    fclose(work.fp);

    /*
     * Stop taking pictures.
     */
    cam->stopTakingPictures();

    return 0;
}

void print_pics()
{
        
    int cnt = 0;
    int c = 0;
    while (cnt < 4) 
    {
       
        char fname[64];
        snprintf(fname, sizeof(fname) - 1, FILENAME, alert_num, cnt);
        int r = capture(&cam1, fname);
        if (r == 0) 
        {
            ++c;
           // DEBMSG("[%04d]:OK.", cnt);
            //NEWLINE();
        } 
        else 
        {
            DEBMSG("[%04d]:NG. (code=%d)", cnt, r);
            NEWLINE();
            error("Failure.");
        }
        cnt++;
    }
    if(c==4)
    {
        printf("All pictures taken \n");
    }
    
    return;
  }

void send_text()
{
    char buf[40];
    char buf2= 0x1A;
    
    gsm.printf("AT\r\n");  //Should return OK
   // gsm.scanf("%s",buf);
   // pc.printf("%s\n",buf);
    
    //gsm.scanf("%s",buf1);
    //pc.printf("%s\n",buf1);
    wait(.5);
    gsm.printf("AT+CSMP=17,167,0,0\r\n");  //Set text mode parameters =<fo>,<vp>,<pid>,<dcs>
    //gsm.scanf("%s",buf);                   // Should return OK
    //gsm.scanf("%s",buf1);
    //pc.printf("%s\n",buf);
    //pc.printf("%s\n",buf1);
    wait(.5);
    gsm.printf("AT+CMGF=1\r\n");      //1 - text mode, indicates the format of messages used with send, list, read and write commands
    //gsm.scanf("%s",buf);               
   // gsm.scanf("%s",buf1);
    //pc.printf("%s\n",buf);
    //pc.printf("%s\n",buf1);
    wait(.5);
    while (1) 
    {
            //pc.printf("message sent");
            gsm.printf("AT+CMGS=\"%s\"\r\n", phone_num);   //AT+CMGS=”<da>"...da - destination address
          //  gsm.scanf("%s",buf);  //Response OK
           // gsm.scanf("%s",buf1);
            //pc.printf("%s\n",buf);
            //pc.printf("%s\n",buf1);
           wait(.5);
            gsm.printf("Alert message #%d %c \r\n", alert_num, buf2);  //Actual message following CMGS command followed by ctrl+z (buf2)
            //gsm.scanf("%s",buf);  //Response OK
           // gsm.scanf("%s",buf1);
            //pc.printf("%s\n",buf);
            //pc.printf("%s\n",buf1);
            pc.printf("Message sent \n");

            break;
    }
 }

void sound_alarm()
{
    ++alert_num;
    pc.printf("\nSound alarm...alert alert\n");
    pc.printf("The value was: %f \n", reading);
    pc.printf("4 Pictures being taken... \n");
    print_pics();
    pc.printf("Pictures have been taken!\n");
    pc.printf("Sending text alert...\n");
    send_text();
    
    
    
    pc.printf("Re-engaging in 10 seconds... \n");
    wait(10);
    return;
}

void init_cam()
{
    if (cam1.reset() == 0) 
    {
        DEBMSG("Reset OK.");
        NEWLINE();
    } 
    else 
    {
        DEBMSG("Reset fail.");
        NEWLINE();
        error("Reset fail.");
    }
    return;
}
  

int main() 
{
    gsm.baud(115200);
    pc.baud(115200);
    //pc.printf("Testing...");
    //send_text();
   
    char user_input[5] = "";
   // user_input = "";
   
    float moving_avg[DEPTH];
    double avg;
    
    //
    while(strcmp(user_input, "y") != 0)
    { 
        pc.printf("Initialize Security System (y/n) \n");
        pc.scanf("%s", user_input);
        pc.printf("Input phone number to send alerts\n");
        pc.scanf("%s", phone_num);
     }
     pc.printf("Initializing...\n");
     init_cam();
     
    int i = 0;
    while(1)
    {
        //Moving average for motion detection
        //moving_avg[i] = motion.read();
        reading = motion.read();
        if(i>=DEPTH) //Check for difference versus moving avg
        {
            if(i == DEPTH)
              pc.printf("Security System Engaged! \n");  
            avg = 0;
            
            for(int j=0; j < DEPTH; ++j)
                avg = avg + moving_avg[j];
            avg = avg/DEPTH;
            pc.printf("Average = %f", avg);
            if((reading > 1.2 * avg)||(reading < .8 *avg))
                {
                    sound_alarm();
                    continue;
                }
            else
                moving_avg[i%DEPTH] = reading;
         }
         else
            moving_avg[i%DEPTH] = reading;
        
        ++i;
        pc.printf("Motion value: %f\n", reading);
        wait(.4);
    }
 
    return 0;
}