#ifndef ROBOT_H
#define ROBOT_H

// This library was designed simplify operation of Stinger robot only with MBED and two H-Bridges.
// Is is still in development.
// Class Robot integrated QEI, PID and Motor classes to work together through use of Ticker function to 
// regularly poll QEI objects, adjust PID and Motor objects.
// Right now all pins have been preassigned, later empty constructor will be added with individual pin assignments.
//    Pinouts are:
//    rightMotor = new Motor(p23, p6, p5); // pwm, fwd, rev
//    leftMotor = new Motor(p22, p8, p7); // pwm, fwd, rev
//    leftQei = new QEI(p29,  p30, NC, 624, QEI::X2_ENCODING);  //chanA, chanB, index, ppr
//    rightQei = new QEI(p27, p28, NC, 624, QEI::X2_ENCODING);  //chanB, chanA, index, ppr
//    leftPid = new PID(0.4312, 0.1, 0.0, RATE);  //Kc, Ti, Td
//    rightPid = new PID(0.4312, 0.1, 0.0, RATE); //Kc, Ti, Td

#include "mbed.h"
#include "Motor.h"
#include "QEI.h"
#include "PID.h"

#define MAX_SPEED 3200
#define RATE 0.05
#define DPP  14.2 //Pulses per degree of motor rotation

/**
 * Robot class.
 */

class Robot {
public:
    /**
    * Constructor
    */    
    Robot();
    /**
    * Destructor
    */  
    virtual ~Robot();
    /**
    * Move Straight
    * @param s  speed between -1.0 and 1.0
    * @param clix Number of pulses to move
    */  
    void    MoveStraightPulses(float s, int clix);
    /**
    * Move Straight
    * @param speed  speed between -1.0 and 1.0
    * @param in Number of inches to move
    */  
    void    MoveStraightInches(float speed, float in);
    /**
    * Move Straight
    * @param seed  speed between -1.0 and 1.0
    * @param rotations Number of wheel rotations to move
    */  
    void    MoveStraightRotations(float speed, float rotations);
    /**
    * Stop Left Wheel
    */  
    void    StopLeft();
    /**
    * Stop Right Wheel
    */  
    void    StopRight();
    /**
    * Stop
    */  
    void    Stop();
    /**
    * Pivet left
    * @param deg degrees
    */  
    void    PivetLeft(float deg);
    /**
    * Pivet right
    * @param deg degrees
    */  
    void    PivetRight(float deg);
    void    RotateLeftWheel(float rpm, float deg);     //Rotate Wheel <deg> Degrees
    void    RotateRightWheel(float rpm, float deg);    //Rotate Wheel <deg> Degrees
    /**
    * Returns 0 if robot is not moving
    * Returns 1 otherwise
    * @returns flat
    */  
    int     IsBusy();


protected:
    Motor   *rightMotor;
    Motor   *leftMotor;
    QEI     *leftQei;
    QEI     *rightQei;
    PID     *leftPid;
    PID     *rightPid;
    Serial  *pc;
    /**
    * Ticker function
    */  
    void    Call();

private:
    Ticker           ticker;
    volatile int     leftPulses;
    volatile int     rightPulses;
    volatile int     leftPrevPulses;
    volatile int     rightPrevPulses;
    volatile int     leftPulsesGoTo;
    volatile int     rightPulsesGoTo;
    volatile int     leftSpeed;
    volatile int     rightSpeed;
    volatile float   rightVelocity;
    volatile float   leftVelocity;
    float   leftDirection;
    float   rightDirection;
};

#endif /* ROBOT_H */
