#include "mbed.h"

#define BOTH_BLINK 0
#define ONLY_RED_BLINK 1
#define ONLY_BLUE_BLINK 2
#define NO_BLINK 3



// Labs 2: Example program for using an interrupt (or callback)
// -----------------------------------------------------------
// A callback function (corresponding to an ISR) is called when a button 
//    is pressed
// The callback uses a shared variable to signal another thread

InterruptIn button1(PTD0);
InterruptIn button2(PTD2);
DigitalOut led1(LED_RED);
DigitalOut led2(LED_BLUE);
Serial pc(USBTX, USBRX); // tx, rx

volatile int redEvent = 0, blueEvent = 0 ;

// This function is invoked when then interrupt occurs
//   Signal that the button has been pressed
//   Note: bounce may occur 
void button1Callback(){
    redEvent = 1 ;
}

void button2Callback(){
    blueEvent = 1 ;
}

/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main() {
    button1.mode(PullUp);             // Ensure button i/p has pull up
    button1.fall(&button1Callback) ;   // Attach function to falling edge
    button2.mode(PullUp);
    button2.fall(&button2Callback);
    //blinkStateLed1 = BLINK;
    //blinkStateLed2 = BLINK;
    led1.write(0);
    led2.write(0);
    int count = 0, systemState = BOTH_BLINK; 
    
    while(true) {
        // Toggle the LED every time the button is pressed
        
        wait(0.1);
        count++;
        
        switch(systemState) {
        case BOTH_BLINK:
            
            if(redEvent) {                                                   // Red LED Stops to Blink
                systemState = ONLY_BLUE_BLINK;
                redEvent = 0; 
                }
            if(blueEvent) {                                                   // Blue LED Stops to Blink
                systemState = ONLY_RED_BLINK;
                blueEvent = 0;
                }
            break;
        
        case ONLY_BLUE_BLINK:
            if(redEvent) {                                                   // Red LED Starts blinking
                systemState = BOTH_BLINK;
                redEvent = 0;
                }
            if(blueEvent) {                                                   //Blue LED Stops to Blink
                systemState = NO_BLINK;
                blueEvent = 0;
                }
        
        case ONLY_RED_BLINK:
            if(redEvent) {                                                   // Red LED Stops to Blink
                systemState = NO_BLINK;
                redEvent = 0;
                }
            if(blueEvent) {                                                   // Blue LED Starts blinking
                systemState = BOTH_BLINK;
                blueEvent = 0; 
                }
        case NO_BLINK:
            if(redEvent) {
                systemState = ONLY_RED_BLINK;
                redEvent = 0;
                }
            if(blueEvent) {
                systemState = ONLY_BLUE_BLINK;
                blueEvent = 0;
                }    
                
        }
        
        /*
        if (pressEvent1) {
            switch (blinkStateLed1) {
            case BLINK:  
                    blinkStateLed1 = NO_BLINK;               
                    break;
            case NO_BLINK:
                    //led1.write(led2.read());
                    blinkStateLed1 = BLINK;
                    break;
            }
            pressEvent1 = 0 ; // Clear the event variable
        }
        
        
        if (pressEvent2) {
            switch (blinkStateLed2) {
                case BLINK:  
                    blinkStateLed2 = NO_BLINK;
                    break;
                case NO_BLINK:
                    //led2.write(led1.read());
                    blinkStateLed2 = BLINK;
                    break;
            }
            pressEvent2 = 0 ; // Clear the event variable
        }
        */
        if(count >= 30)
        {
            count = 0; 
            if (systemState == BOTH_BLINK) {
                led1 = !led1;
                led2 = !led2;
            }
            
            else if (systemState == ONLY_RED_BLINK) {
                led1 = !led1;
            }
            else if (systemState == ONLY_BLUE_BLINK) {
                led2 = !led2; 
                
            }
        }
        pc.printf("%d", systemState);
        pc.putc('\r');
        pc.putc('\n');
        

    }
}