#include "pid_controller.h"
#include "globals.h"

PIDController::PIDController() {
    this->reset();
}

/***
 * Assignment 3
 * 
 * Implement PID!
 ***/

void PIDController::reset() volatile {    
    /**
     * You'll have a lot to keep track of. Make sure to reset all 
     * those variables here.
     **/

    m_goalW = 0;
    m_goalX = 0;

    m_pwmW = 0;
    m_pwmX = 0;

    m_errorW = 0;
    m_errorX = 0;
    m_errorW_old = 0;
    m_errorX_old = 0;

    m_countsW = 0;
    m_countsX = 0;
    
    counter = 0;
}

void PIDController::update() volatile {
    /**
     * Update your PID controller. This is what should be called
     * every systick, so you should call all your important
     * functions here.
     **/
     getSensorFeedback();
     x_controller();
     w_controller();
     updateMotorPwm();
}

void PIDController::setXGoal(int counts) {
    /**
     * Set goal for X controller.
     **/
     m_goalX = counts;
}

void PIDController::setWGoal(int counts) {
    /**
     * Set goal for W controller. Make sure to associate a turning
     * direction with a sign, e.g., positive is clockwise, negative
     * is counter-clockwise.
     **/
     m_goalW = counts;
}

bool PIDController::isDone() volatile {
    /**
     * When is the PID done? Well, probably when you've reached
     * your goals...
     **/
/*     int counter = 0;
     while (counter < 3){
        if ((m_errorW < 10 && m_errorW > -10) && (m_errorX < 10 && m_errorX > -10))
            counter++; 
         }
     
     return true;*/
//     return ((m_errorX < 10 && m_errorX > -10) && (m_errorW < 10 && m_errorW > -10));
    return counter > 100; //counter > threshold;

}

char* PIDController::getData() {
    /**
     * Use this function to print data about your PID,
     * because you can't print directly in systick!
     **/
     
         sprintf(buf, "goalx: %d\tgoalw: %d\tpwmx: %.3f\tpwmw: %.3f\terrorx: %d\terrorw: %d\n",
        m_goalX,
        m_goalW,
        m_pwmX,
        m_pwmW,
        m_errorX,
        m_errorW);
    return buf;
     
     
/*    sprintf(buf, "goalx: %d\tgoalw: %d\tpwmx: %.3f\tpwmw: %.3f/terrorx: %d\terrorw: %d\n",
        m_goalX,
        m_goalW,
        m_pwmX,
        m_pwmW
        m_errorX,
        m_errorW
       // m_countsW
        );
    return buf;*/
}

/**
 * Private functions to do the internal work for PID.
 **/
void PIDController::getSensorFeedback() volatile {
    /**
     * Update sensor values, from encoders
     **/
    m_countsX = (encoders.getPulsesL() + encoders.getPulsesR()) / 2;

    m_countsW = encoders.getPulsesL() - encoders.getPulsesR();

}

void PIDController::x_controller() volatile {
    /**
     * Your X PID controller, sets m_pwmX
     **/
     
    m_errorX = m_goalX - m_countsX;
    m_pwmX = KpX * m_errorX + KdX * (m_errorX - m_errorX_old) * SYS_TICK_TIME;

    m_errorX_old = m_errorX;
//    m_pwmX = 0.15;

}

void PIDController::w_controller() volatile {
  /**
     * Your W PID controller, sets m_pwmW
     **/
    m_errorW =  m_goalW - m_countsW + ir.get_ir_error() * 0.1;
    //m_errorW =  m_goalW - m_countsW;
    m_pwmW = KpW * m_errorW + KdW * (m_errorW - m_errorW_old) * SYS_TICK_TIME;

    m_errorW_old = m_errorW;
    
        // Don't go too fast!
    //adjust_pwm(&m_pwmW );

}

void PIDController::updateMotorPwm() volatile {
    /**
     * Takes m_pwmX, m_pwmW, and adjusts the motors based on those values.
     **/

    m_pwmX = limit_pwm(m_pwmX);
    m_pwmW = limit_pwm(m_pwmW);

    if((m_pwmX + m_pwmW) < MIN_SPEED && (m_pwmX - m_pwmW) < MIN_SPEED){
      counter++;
    }
    
    motors.setRightPwm(m_pwmX - m_pwmW);
    motors.setLeftPwm(m_pwmX + m_pwmW);
}

void PIDController::zero_encoders() {
    encoders.reset();
}

void PIDController::zero_errors() {
    m_errorW =  0;
    m_errorW_old = 0;
    m_errorX =  0;
    m_errorX_old = 0;
}

void PIDController::zero_counter() {
    counter = 0;
}

float PIDController::limit_pwm(float pwm) volatile {
    if (abs(pwm) > MAX_SPEED) {
        if (pwm > 0) pwm = MAX_SPEED;
        else if (pwm < 0) pwm = -MAX_SPEED;
    }
    return pwm;
}

