#include <string>

#include "main_controller.h"
#include "pid_controller.h"

MainController::MainController() {
    m_pid = new PIDController;
}

MainController::~MainController() {
    delete m_pid;
}

/***
 * Assignment 3
 * 
 * Implement PID! Most of this work is done in "pid_controller".
 ***/
void MainController::update() {
    // Update PID controller. This is the function you should be
    // calling every systick.
    m_pid->update();
}

/***
 * Assignment 3: Part 1
 * 
 * Get your mouse driving straight.
 ***/
void MainController::driveStraight() {
    
    /**
     * Set an X goal and W goal correctly! This is discussed in the lecture slides.
     * For help, see example code: pid/drive-straight.cpp
     **/

    //convert to count is an equation?
    //int x_counts = convert_to_counts(how_many);
    //int w_counts = convert_to_counts(how_many); 

    // this does turning right 90 deg
    m_pid->setXGoal(0); //used to be x_counts
    m_pid->setWGoal(425); // 5 counts per degree
    
    
    while (!m_pid->isDone()) {
        update();
        pc.printf(m_pid->getData());
//        wait(0.1);
    }

    
    //pc.printf("Finished action.");


    pc.printf("Driving straight\n");
}

/***
 * Assignment 3: Part 2
 * 
 * Get your mouse to turn, and drive a specific distance.
 ***/
void MainController::turn(int deg) {
    /**
     * For help, see example code: pid/turning.cpp
     **/
    pc.printf("Turning %d degrees\n", deg);
    
    int w_counts = deg*5; ///4.72222222    
    m_pid->setXGoal(0);
    m_pid->setWGoal(w_counts);
    
    m_pid->zero_encoders();
    m_pid->zero_errors();
    m_pid->zero_counter();
    
//    update();
    
    while (!m_pid->isDone()) {
        update();
        pc.printf(m_pid->getData());
        wait(0.1);
    }
    
    pc.printf("Turned %d degrees\n", deg);
    wait(0.1);
}

void MainController::moveCells(float n) {
    /**
     * For help, see example code: pid/full.cpp
     **/
    
 //   pc.printf("Moving %.1f cells\n", n); 
    
    int x_counts = n*660; // encoder counts per cell // 630
    
    m_pid->setXGoal(x_counts);
    m_pid->setWGoal(0);

    m_pid->zero_encoders();
    m_pid->zero_errors();
    m_pid->zero_counter();
 //   pc.printf("OK.");
//    update();
    
   // pc.printf(m_pid->getData());
    //encoders.printValues();
    
    while (!m_pid->isDone()) {
        update();
      //  pc.printf(m_pid->getData());
        wait(0.1);
    }
   // pc.printf("Moved %.1f cells\n", n); 
   //encoders.printValues();

    wait(0.1);
}


