#pragma once
#include "globals.h"

const float KpX = 0.002; //1
const float KdX = 0.001; //1

const float KpW = 0.002; 
const float KdW = 0.001; //1

class PIDController {
public:
    PIDController();
    
    void reset() volatile;
    void update() volatile;

    void setXGoal(int counts);
    void setWGoal(int counts);

    bool isDone() volatile;
    char* getData();
    
    // added
    void zero_encoders();
    void zero_errors();
    void zero_counter();
    
private:
    void getSensorFeedback() volatile;
    void x_controller() volatile;
    void w_controller() volatile;
    void updateMotorPwm() volatile;
    
    float limit_pwm(float pwm) volatile;
    
    int m_goalW;
    int m_goalX;
    
    float m_pwmW;
    float m_pwmX;
    
    float m_errorW;
    int m_errorX;
    int m_errorW_old;
    int m_errorX_old;
    
    int m_countsW;
    int m_countsX;
    
    int counter;
    
    char buf[200];
};

