#include "ir.h"
#include "pins.h"
#include "globals.h"


DigitalOut ir_L(IR_L);
AnalogIn rec_L(REC_L);

DigitalOut ir_R(IR_R);
AnalogIn rec_R(REC_R);

DigitalOut ir_FL(IR_FL);
AnalogIn rec_FL(REC_FL);

DigitalOut ir_FR(IR_FR);
AnalogIn rec_FR(REC_FR);


Ir::Ir(){
    reset();
}

void Ir::reset() volatile {
     m_recL = 0;
     m_recR = 0;
     m_recFL = 0;
     m_recFR = 0;
}

float Ir::left() volatile{
    return m_recL;
}

float Ir::right() volatile {
    return m_recR;
}

bool Ir::wallFront(DigitalOut ir_FR, DigitalOut ir_FL, AnalogIn rec_FR, AnalogIn rec_FL) volatile {
    return flash_ir(ir_FR, rec_FR) >= 0.7 && flash_ir(ir_FL, rec_FL) >= 0.7;
}

bool Ir::wallLeft(DigitalOut ir_L, AnalogIn rec_L) volatile {
    return flash_ir(ir_L, rec_L) >= 0.7;
}
bool Ir::wallRight(DigitalOut ir_R, AnalogIn rec_R) volatile {
    return flash_ir(ir_R, rec_R) >= 0.7;
}

float Ir::flash_ir(DigitalOut ir, AnalogIn rec) volatile {
    float init = rec.read();

    ir = 1;
    wait_us(50); // WARM_UP_US
    
    int n = 10;
    float total = 0;
       
    for (int i = 0; i < n; i++) {
        total += rec.read();   
    }

    ir = 0;
    wait_us(50); // COOL_DOWN_US
    
    return total / n - init;
}



float Ir::get_ir_error() {
    float error;
    float MIDL = 0.6;
    float MIDR = 0.4;
    
    update();
    
//    float right = flash_ir(ir_R, rec_R);
//    float left = flash_ir(ir_L, rec_L);

    float right = m_recR;
    float left = m_recL;

    /*
    - These MID values can be hardcoded, or maybe even calculated at some
    point in your program...
    - You may find that setting these mid values to something that doesn't
    quite correspond to the middle (e.g., MIDR slightly to the right of the
    middle rather that directly in the center), may make your Rat perform
    better. Play around with it!
    */  
    if ( right > MIDR) {
        error = right - MIDR;
    }
    else if ( left > MIDL) {
        // Make sure to change the sign for the error!
        error = MIDL - left;
    }
    else {
        // No useful information from IR's
        error = 0;
    }

    return error;
}

void Ir::update() volatile {
    m_recL = flash_ir(ir_L, rec_L);
    m_recR = flash_ir(ir_R, rec_R); 
    m_recFL = flash_ir(ir_FL, rec_FL);
    m_recFR = flash_ir(ir_FR, rec_FR);
    }
    
void Ir::printValues() volatile{
    pc.printf("L: %d\tR: %d\n", left(), right());
    //pc.printf("L: %d\tR: %d\tFL: %d\tFR: %d", left(), right(), frontleft(), frontright());
    }

